/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.util.HostUtil;

public class UrlMapperValve
implements CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(UrlMapperValve.class);

    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.process(request, response);
        }
        catch (Exception e) {
            log.error((Object)"error in forwarding the url", (Throwable)e);
        }
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uri;
        String serverName = request.getServerName();
        String queryString = request.getQueryString();
        try {
            uri = HostUtil.getServiceNameForHost(serverName);
        }
        catch (UrlMapperException e1) {
            log.error((Object)"error in retriving  the service url", (Throwable)e1);
            throw e1;
        }
        if (uri != null) {
            if (queryString != null) {
                try {
                    String filterUri = uri.substring(0, uri.length() - 1);
                    String endUrl = "/services" + filterUri + "?" + queryString;
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(endUrl);
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception e) {
                    log.error((Object)"error in forwarding the url", (Throwable)e);
                    throw e;
                }
            }
            RequestDispatcher patcher = request.getRequestDispatcher("");
            try {
                patcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                log.error((Object)"error in forwarding the url", (Throwable)e);
                throw e;
            }
        }
    }
}

