/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.url.mapper.data.MappingData;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.util.HostUtil;

public class UrlMapperAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(UrlMapperAdminService.class);

    public void addWebAppToHost(String hostName, String uri) throws UrlMapperException {
        try {
            hostName = hostName + ".wso2.com";
            HostUtil.addWebAppToHost(hostName, uri);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UrlMapperException("Failed to add webapp to host ", e);
        }
    }

    public static MappingData[] getAllMappings() throws UrlMapperException {
        return HostUtil.getAllMappingsFromRegistry();
    }

    public void addServiceDomain(String hostName, String url) throws UrlMapperException {
        hostName = hostName + ".wso2.com";
        HostUtil.addDomainToServiceEpr(hostName, url);
    }

    public void editServiceDomain(String newHost, String oldhost) throws UrlMapperException {
        newHost = newHost + ".wso2.com";
        HostUtil.updateEprToRegistry(newHost, oldhost);
    }

    public void deleteServiceDomain(String hostName) throws UrlMapperException {
        HostUtil.deleteResourceToRegistry(hostName);
    }

    public String[] getHostForEpr(String url) throws UrlMapperException {
        List<String> domains = HostUtil.getMappingsPerEppr(url);
        return domains.toArray(new String[domains.size()]);
    }

    public String[] getHostForWebApp(String url) throws UrlMapperException {
        List<String> domains = HostUtil.getMappingsPerWebApp(url);
        return domains.toArray(new String[domains.size()]);
    }

    public boolean editHost(String webappName, String newHost, String oldhost) throws UrlMapperException {
        newHost = newHost + ".wso2.com";
        HostUtil.editHostInEngine(webappName, newHost, oldhost);
        return true;
    }

    public void deleteHost(String hostName) throws UrlMapperException {
        HostUtil.removeHost(hostName);
    }

    public boolean isMappingExist(String mappingName) throws UrlMapperException {
        return HostUtil.isMappingExist(mappingName);
    }
}

