/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.url.mapper.stub.UrlMapperAdminServiceStub;
import org.wso2.carbon.url.mapper.stub.types.carbon.MappingData;

public class UrlMapperServiceClient {
    UrlMapperAdminServiceStub stub;
    private static final Log log = LogFactory.getLog(UrlMapperServiceClient.class);

    public UrlMapperServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "UrlMapperAdminService";
        this.stub = new UrlMapperAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public MappingData[] getAllMappings() throws Exception {
        try {
            return this.stub.getAllMappings();
        }
        catch (Exception e) {
            String msg = "Error getting URL Mappings. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean editHost(String webappName, String oldhost, String newHost) throws Exception {
        try {
            return this.stub.editHost(webappName, oldhost, newHost);
        }
        catch (Exception e) {
            String msg = "Error occurred while editing  host. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void editServiceDomain(String newHost, String oldhost) throws Exception {
        try {
            this.stub.editServiceDomain(newHost, oldhost);
        }
        catch (Exception e) {
            String msg = "Error occurred while editing service host. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void removeServiceDomain(String host) throws Exception {
        try {
            this.stub.deleteServiceDomain(host);
        }
        catch (Exception e) {
            String msg = "Error occurred while deleting service host. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addServiceDomain(String host, String epr) throws Exception {
        try {
            this.stub.addServiceDomain(host, epr);
        }
        catch (Exception e) {
            String msg = "Error occurred while adding new domain to " + epr + ". Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void deleteHost(String host) throws Exception {
        try {
            this.stub.deleteHost(host);
        }
        catch (Exception e) {
            String msg = "Error occurred while deleting host. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addWebAppToHost(String appId, String context) throws Exception {
        try {
            String hostName = appId;
            boolean isDomain = this.isMappingExist(hostName);
            if (!isDomain) {
                this.stub.addWebAppToHost(hostName, context);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while adding webb app to host. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getHostForWebApp(String webAppName) throws Exception {
        try {
            return this.stub.getHostForWebApp(webAppName);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting hosts for web application. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getHostForEpr(String epr) throws Exception {
        try {
            return this.stub.getHostForEpr(epr);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting hosts for web application. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean isMappingExist(String mappingName) throws Exception {
        try {
            return this.stub.isMappingExist(mappingName);
        }
        catch (Exception e) {
            String msg = "Error occurred while checking domain exsistance. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }
}

