/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.unifiedendpoint.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpointFactory;
import org.wso2.carbon.unifiedendpoint.stub.types.UnifiedEndpointAdminStub;

public class UnifiedEndpointAdminClient {
    private UnifiedEndpointAdminStub stub;

    public UnifiedEndpointAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "UnifiedEndpointAdmin";
        this.stub = new UnifiedEndpointAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String saveUEP(String key, String ele) {
        String temp = "";
        try {
            temp = this.stub.saveUnifiedEP(key, ele);
        }
        catch (Exception e) {
            // empty catch block
        }
        return temp;
    }

    public String[] getAllEndpoints(int pageNumber, int endpointsPerPage) {
        String[] epList = null;
        try {
            epList = this.stub.getDynamicEndpoints(pageNumber, endpointsPerPage);
        }
        catch (Exception e) {
            // empty catch block
        }
        return epList;
    }

    public UnifiedEndpoint getEndpoint(String uepId) {
        UnifiedEndpoint unifiedEndpoint = null;
        String[] uepArray = null;
        try {
            for (String uepStr : uepArray = this.stub.getDynamicEndpoints(10, 10)) {
                UnifiedEndpoint uep;
                if (uepStr == null || (uep = new UnifiedEndpointFactory().createEndpoint(uepStr)) == null || !uep.getUepId().equals(uepId)) continue;
                unifiedEndpoint = uep;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return unifiedEndpoint;
    }
}

