/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.core.UserStoreException;

public class Util {
    private static Log log = LogFactory.getLog(Util.class.getClass());

    static void checkAccess(String resourceId) throws UserStoreException {
        if (Util.isSuperTenantResource(resourceId) && !Util.isSuperTenant()) {
            StringBuilder stringBuilder = new StringBuilder("Unauthorized attempt to modify super tenant resource by tenant domain - ");
            stringBuilder.append(CarbonContext.getCurrentContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getCurrentContext().getTenantId()).append(" user - ").append(CarbonContext.getCurrentContext().getUsername());
            log.warn((Object)stringBuilder.toString());
            throw new UserStoreException("Access Denied");
        }
    }

    private static boolean isSuperTenantResource(String resource) {
        return resource.contains("protected");
    }

    static boolean isSuperTenant() {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        return tenantId == 0;
    }
}

