/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.um.ws.service.Util;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.mgt.common.ClaimValue;

public class UserStoreManagerService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(UserStoreManagerService.class.getClass());

    public void addUser(String userName, String credential, String[] roleList, ClaimValue[] claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.getUserStoreManager().addUser(userName, (Object)credential, roleList, this.convertClaimValueToMap(claims), profileName, requirePasswordChange);
    }

    public void setUserClaimValues(String userName, ClaimValue[] claims, String profileName) throws UserStoreException {
        this.getUserStoreManager().setUserClaimValues(userName, this.convertClaimValueToMap(claims), profileName);
    }

    public ClaimValue[] getUserClaimValuesForClaims(String userName, String[] claims, String profileName) throws UserStoreException {
        return this.convertMapToClaimValue(this.getUserStoreManager().getUserClaimValues(userName, claims, profileName));
    }

    public void addRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        this.getUserStoreManager().addRole(roleName, userList, permissions);
    }

    public Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        return this.getUserStoreManager().getUserClaimValues(userName, profileName);
    }

    public boolean authenticate(String userName, String credential) throws UserStoreException {
        return this.getUserStoreManager().authenticate(userName, (Object)credential);
    }

    public void updateCredential(String userName, String newCredential, String oldCredential) throws UserStoreException {
        this.getUserStoreManager().updateCredential(userName, (Object)newCredential, (Object)oldCredential);
    }

    public void updateCredentialByAdmin(String userName, String newCredential) throws UserStoreException {
        this.getUserStoreManager().updateCredentialByAdmin(userName, (Object)newCredential);
    }

    public long getPasswordExpirationTime(String username) throws UserStoreException {
        Date date = this.getUserStoreManager().getPasswordExpirationTime(username);
        if (date != null) {
            return date.getTime();
        }
        return -1L;
    }

    public void deleteRole(String roleName) throws UserStoreException {
        this.getUserStoreManager().deleteRole(roleName);
    }

    public void deleteUser(String userName) throws UserStoreException {
        this.getUserStoreManager().deleteUser(userName);
    }

    public void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        this.getUserStoreManager().deleteUserClaimValue(userName, claimURI, profileName);
    }

    public void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        this.getUserStoreManager().deleteUserClaimValues(userName, claims, profileName);
    }

    public String[] getAllProfileNames() throws UserStoreException {
        return this.getUserStoreManager().getAllProfileNames();
    }

    public String[] getHybridRoles() throws UserStoreException {
        return this.getUserStoreManager().getHybridRoles();
    }

    public String[] getProfileNames(String userName) throws UserStoreException {
        return this.getUserStoreManager().getProfileNames(userName);
    }

    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        return this.getUserStoreManager().getRoleListOfUser(userName);
    }

    public String[] getRoleNames() throws UserStoreException {
        return this.getUserStoreManager().getRoleNames();
    }

    public int getTenantId() throws UserStoreException {
        return this.getUserStoreManager().getTenantId();
    }

    public int getTenantIdofUser(String username) throws UserStoreException {
        if (Util.isSuperTenant()) {
            return this.getUserStoreManager().getTenantId(username);
        }
        StringBuilder stringBuilder = new StringBuilder("Unauthorized attempt to execute super tenant operation by tenant domain - ");
        stringBuilder.append(CarbonContext.getCurrentContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getCurrentContext().getTenantId()).append(" user - ").append(CarbonContext.getCurrentContext().getUsername());
        log.warn((Object)stringBuilder.toString());
        throw new UserStoreException("Access Denied");
    }

    public String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        return this.getUserStoreManager().getUserClaimValue(userName, claim, profileName);
    }

    public int getUserId(String username) throws UserStoreException {
        return this.getUserStoreManager().getUserId(username);
    }

    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        return this.getUserStoreManager().getUserListOfRole(roleName);
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        return this.getUserStoreManager().isExistingRole(roleName);
    }

    public boolean isExistingUser(String userName) throws UserStoreException {
        return this.getUserStoreManager().isExistingUser(userName);
    }

    public boolean isReadOnly() throws UserStoreException {
        return this.getUserStoreManager().isReadOnly();
    }

    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        return this.getUserStoreManager().listUsers(filter, maxItemLimit);
    }

    public void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        this.getUserStoreManager().setUserClaimValue(userName, claimURI, claimValue, profileName);
    }

    public void updateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        this.getUserStoreManager().updateRoleListOfUser(userName, deletedRoles, newRoles);
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        this.getUserStoreManager().updateRoleName(roleName, newRoleName);
    }

    public void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        this.getUserStoreManager().updateUserListOfRole(roleName, deletedUsers, newUsers);
    }

    private UserStoreManager getUserStoreManager() throws UserStoreException {
        try {
            UserRealm realm = super.getUserRealm();
            if (realm == null) {
                throw new UserStoreException("UserRealm is null");
            }
            return realm.getUserStoreManager();
        }
        catch (Exception e) {
            throw new UserStoreException((Throwable)e);
        }
    }

    private Map<String, String> convertClaimValueToMap(ClaimValue[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ClaimValue claimValue : values) {
            map.put(claimValue.getClaimURI(), claimValue.getValue());
        }
        return map;
    }

    private ClaimValue[] convertMapToClaimValue(Map<String, String> map) {
        ClaimValue[] claims = new ClaimValue[map.size()];
        Iterator<Map.Entry<String, String>> ite = map.entrySet().iterator();
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry<String, String> entry = ite.next();
            claims[i] = new ClaimValue();
            claims[i].setClaimURI(entry.getKey());
            claims[i].setValue(entry.getValue());
            ++i;
        }
        return claims;
    }

    public String[][] getProperties(Tenant tenant) throws UserStoreException {
        if (!Util.isSuperTenant()) {
            StringBuilder stringBuilder = new StringBuilder("Unauthorized attempt to execute super tenant operation by tenant domain - ");
            stringBuilder.append(CarbonContext.getCurrentContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getCurrentContext().getTenantId()).append(" user - ").append(CarbonContext.getCurrentContext().getUsername());
            log.warn((Object)stringBuilder.toString());
            throw new UserStoreException("Access Denied");
        }
        return null;
    }
}

