/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.um.ws.service.Util;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class AuthorizationManagerService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(AuthorizationManagerService.class.getClass());

    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        Util.checkAccess(resourceId);
        this.getAuthorizationManager().authorizeRole(roleName, resourceId, action);
    }

    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        Util.checkAccess(resourceId);
        this.getAuthorizationManager().authorizeUser(userName, resourceId, action);
    }

    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        this.getAuthorizationManager().clearResourceAuthorizations(resourceId);
    }

    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        this.getAuthorizationManager().clearRoleActionOnAllResources(roleName, action);
    }

    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName, resourceId, action);
    }

    public void clearAllRoleAuthorization(String roleName) throws UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName, resourceId, action);
    }

    public void clearAllUserAuthorization(String userName) throws UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName);
    }

    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        this.getAuthorizationManager().denyRole(roleName, resourceId, action);
    }

    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        this.getAuthorizationManager().denyUser(userName, resourceId, action);
    }

    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().getAllowedRolesForResource(resourceId, action);
    }

    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().getDeniedRolesForResource(resourceId, action);
    }

    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().getExplicitlyAllowedUsersForResource(resourceId, action);
    }

    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().getExplicitlyDeniedUsersForResource(resourceId, action);
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().isRoleAuthorized(roleName, resourceId, action);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        return this.getAuthorizationManager().isUserAuthorized(userName, resourceId, action);
    }

    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForUser(userName, permissionRootPath);
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        this.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
    }

    private AuthorizationManager getAuthorizationManager() throws UserStoreException {
        try {
            UserRealm realm = super.getUserRealm();
            if (realm == null) {
                log.error((Object)"User realm is null");
                throw new UserStoreException("UserRealm is null");
            }
            return realm.getAuthorizationManager();
        }
        catch (Exception e) {
            throw new UserStoreException((Throwable)e);
        }
    }
}

