/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.um.ws.api.stub.Claim;
import org.wso2.carbon.um.ws.api.stub.ClaimMapping;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.ProfileConfiguration;
import org.wso2.carbon.um.ws.api.stub.RealmConfigurationDTO;
import org.wso2.carbon.um.ws.api.stub.RealmPropertyDTO;
import org.wso2.carbon.user.api.RealmConfiguration;

public class WSRealmUtil {
    public static Map<String, String> convertClaimValueToMap(ClaimValue[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (values == null) {
            return map;
        }
        for (ClaimValue claimValue : values) {
            map.put(claimValue.getClaimURI(), claimValue.getValue());
        }
        return map;
    }

    public static ClaimValue[] convertMapToClaimValue(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        ClaimValue[] claims = new ClaimValue[map.size()];
        Iterator<Map.Entry<String, String>> ite = map.entrySet().iterator();
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry<String, String> entry = ite.next();
            claims[i] = new ClaimValue();
            claims[i].setClaimURI(entry.getKey());
            claims[i].setValue(entry.getValue());
            ++i;
        }
        return claims;
    }

    public static Map<String, String> convertClaimValuesToMap(ClaimValue[] claims) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (claims == null) {
            return map;
        }
        for (ClaimValue claim : claims) {
            map.put(claim.getClaimURI(), claim.getValue());
        }
        return map;
    }

    public static ClaimMapping[] convertToADBClaimMappings(org.wso2.carbon.user.core.claim.ClaimMapping[] claimMappings) {
        if (claimMappings == null) {
            return null;
        }
        ClaimMapping[] cms = new ClaimMapping[claimMappings.length];
        int i = 0;
        for (org.wso2.carbon.user.core.claim.ClaimMapping claimMapping : claimMappings) {
            ClaimMapping cm = new ClaimMapping();
            cm.setClaim(WSRealmUtil.convertToADBClaim(claimMapping.getClaim()));
            cm.setMappedAttribute(claimMapping.getMappedAttribute());
            cms[i] = cm;
            ++i;
        }
        return cms;
    }

    public static Claim convertToADBClaim(org.wso2.carbon.user.core.claim.Claim claim) {
        if (claim == null) {
            return null;
        }
        Claim claimz = new Claim();
        claimz.setClaimUri(claim.getClaimUri());
        claimz.setDescription(claim.getDescription());
        claimz.setDialectURI(claim.getDialectURI());
        claimz.setDisplayOrder(claim.getDisplayOrder());
        claimz.setDisplayTag(claim.getDisplayTag());
        claimz.setRegEx(claim.getRegEx());
        claimz.setRequired(claim.isRequired());
        claimz.setSupportedByDefault(claim.isSupportedByDefault());
        claimz.setValue(claim.getValue());
        return claimz;
    }

    public static ClaimMapping convertToADBClaimMapping(org.wso2.carbon.user.core.claim.ClaimMapping claimMapping) {
        if (claimMapping == null) {
            return null;
        }
        ClaimMapping cm = new ClaimMapping();
        cm.setClaim(WSRealmUtil.convertToADBClaim(claimMapping.getClaim()));
        cm.setMappedAttribute(claimMapping.getMappedAttribute());
        return cm;
    }

    public static Claim[] convertToADBClaims(org.wso2.carbon.user.core.claim.Claim[] claims) {
        if (claims == null) {
            return null;
        }
        Claim[] claimz = new Claim[claims.length];
        for (int i = 0; i < claims.length; ++i) {
            claimz[i] = WSRealmUtil.convertToADBClaim(claims[i]);
        }
        return claimz;
    }

    public static ProfileConfiguration convertToADBProfileConfiguration(org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig) {
        if (profileConfig == null) {
            return null;
        }
        ProfileConfiguration profz = new ProfileConfiguration();
        profz.setDialectName(profileConfig.getDialectName());
        List lst = profileConfig.getHiddenClaims();
        profz.setHiddenClaims(lst.toArray(new String[lst.size()]));
        lst = profileConfig.getInheritedClaims();
        profz.setInheritedClaims(lst.toArray(new String[lst.size()]));
        lst = profileConfig.getOverriddenClaims();
        profz.setOverriddenClaims(lst.toArray(new String[lst.size()]));
        profz.setProfileName(profileConfig.getProfileName());
        return profz;
    }

    public static RealmConfiguration convertToRealmConfiguration(RealmConfigurationDTO realmConfigDTO) {
        RealmConfiguration realmConfig = new RealmConfiguration();
        realmConfig.setRealmClassName(realmConfigDTO.getRealmClassName());
        realmConfig.setUserStoreClass(realmConfigDTO.getUserStoreClass());
        realmConfig.setAuthorizationManagerClass(realmConfigDTO.getAuthorizationManagerClass());
        realmConfig.setAdminRoleName(realmConfigDTO.getAdminRoleName());
        realmConfig.setAdminUserName(realmConfigDTO.getAdminUserName());
        realmConfig.setAdminPassword(realmConfigDTO.getAdminPassword());
        realmConfig.setEveryOneRoleName(realmConfigDTO.getEveryOneRoleName());
        realmConfig.setUserStoreProperties(WSRealmUtil.getPropertyValueMap(realmConfigDTO.getUserStoreProperties()));
        realmConfig.setAuthzProperties(WSRealmUtil.getPropertyValueMap(realmConfigDTO.getAuthzProperties()));
        realmConfig.setRealmProperties(WSRealmUtil.getPropertyValueMap(realmConfigDTO.getRealmProperties()));
        return realmConfig;
    }

    private static Map<String, String> getPropertyValueMap(RealmPropertyDTO[] properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties == null) {
            return map;
        }
        for (int i = 0; i < properties.length; ++i) {
            map.put(properties[i].getName(), properties[i].getValue());
        }
        return map;
    }

    public static org.wso2.carbon.user.core.claim.Claim[] convertToClaims(Claim[] claims) {
        if (claims == null) {
            return null;
        }
        org.wso2.carbon.user.core.claim.Claim[] claimz = new org.wso2.carbon.user.core.claim.Claim[claims.length];
        int i = 0;
        for (Claim claim : claims) {
            claimz[i] = WSRealmUtil.convertToClaim(claim);
            ++i;
        }
        return claimz;
    }

    public static org.wso2.carbon.user.core.claim.Claim convertToClaim(Claim claim) {
        if (claim == null) {
            return null;
        }
        org.wso2.carbon.user.core.claim.Claim claimz = new org.wso2.carbon.user.core.claim.Claim();
        claimz.setClaimUri(claim.getClaimUri());
        claimz.setDescription(claim.getDescription());
        claimz.setDialectURI(claim.getDialectURI());
        claimz.setDisplayOrder(claim.getDisplayOrder());
        claimz.setDisplayTag(claim.getDisplayTag());
        claimz.setRegEx(claim.getRegEx());
        claimz.setRequired(claim.getRequired());
        claimz.setSupportedByDefault(claim.getSupportedByDefault());
        claimz.setValue(claim.getValue());
        return claimz;
    }

    public static org.wso2.carbon.user.core.claim.ClaimMapping convertToClaimMapping(ClaimMapping claimMapping) {
        if (claimMapping == null) {
            return null;
        }
        org.wso2.carbon.user.core.claim.ClaimMapping cm = new org.wso2.carbon.user.core.claim.ClaimMapping();
        cm.setClaim((org.wso2.carbon.user.api.Claim)WSRealmUtil.convertToClaim(claimMapping.getClaim()));
        cm.setMappedAttribute(claimMapping.getMappedAttribute());
        return cm;
    }

    public static org.wso2.carbon.user.core.profile.ProfileConfiguration convertToProfileConfiguration(ProfileConfiguration profileConfig) {
        if (profileConfig == null) {
            return null;
        }
        org.wso2.carbon.user.core.profile.ProfileConfiguration profz = new org.wso2.carbon.user.core.profile.ProfileConfiguration();
        profz.setDialectName(profileConfig.getDialectName());
        profz.setHiddenClaims(Arrays.asList(profileConfig.getHiddenClaims()));
        profz.setInheritedClaims(Arrays.asList(profileConfig.getInheritedClaims()));
        profz.setOverriddenClaims(Arrays.asList(profileConfig.getOverriddenClaims()));
        profz.setProfileName(profileConfig.getProfileName());
        return profz;
    }

    public static org.wso2.carbon.user.core.profile.ProfileConfiguration[] convertToProfileConfigurations(ProfileConfiguration[] profileConfigs) {
        if (profileConfigs == null) {
            return null;
        }
        org.wso2.carbon.user.core.profile.ProfileConfiguration[] configz = new org.wso2.carbon.user.core.profile.ProfileConfiguration[profileConfigs.length];
        int i = 0;
        for (ProfileConfiguration config : profileConfigs) {
            configz[i] = WSRealmUtil.convertToProfileConfiguration(config);
            ++i;
        }
        return configz;
    }
}

