/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealm;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class WSRealmBuilder {
    private static Log logger = LogFactory.getLog(WSRealmBuilder.class);

    public static UserRealm createWSRealm(RealmConfiguration realmConfig) throws UserStoreException {
        WSRealm realm = new WSRealm();
        try {
            realm.init(realmConfig, null, null, -1);
        }
        catch (UserStoreException e) {
            String errorMessage = "Cannot initialize the realm.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, (Throwable)e);
        }
        return realm;
    }

    public static UserRealm createWSRealm(RealmConfiguration realmConfig, ConfigurationContext configContext) throws UserStoreException {
        WSRealm realm = new WSRealm();
        realm.init(realmConfig, configContext);
        return realm;
    }

    public static UserRealm createWSRealm(String serverUrl, String cookie, ConfigurationContext configContext) throws UserStoreException {
        WSRealm realm = new WSRealm();
        realm.init(serverUrl, cookie, configContext);
        return realm;
    }
}

