/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSUserStoreManager;
import org.wso2.carbon.um.ws.api.stub.RemoteAuthorizationManagerServiceStub;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public class WSAuthorizationManager
implements AuthorizationManager {
    private RemoteAuthorizationManagerServiceStub stub = null;
    private static Log log = LogFactory.getLog(WSUserStoreManager.class);

    public WSAuthorizationManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            this.stub = new RemoteAuthorizationManagerServiceStub(configCtxt, serverUrl + "RemoteAuthorizationManagerService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            throw new UserStoreException();
        }
    }

    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.authorizeRole(roleName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.authorizeUser(userName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        try {
            this.stub.clearResourceAuthorizations(resourceId);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        try {
            this.stub.clearRoleActionOnAllResources(roleName, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.clearRoleAuthorization(roleName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearRoleAuthorization(String roleName) throws UserStoreException {
        try {
            this.stub.clearAllRoleAuthorization(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.clearUserAuthorization(userName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void clearUserAuthorization(String userName) throws UserStoreException {
        try {
            this.stub.clearAllUserAuthorization(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.denyRole(roleName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        try {
            this.stub.denyUser(userName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.getAllowedRolesForResource(resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        try {
            return this.stub.getAllowedUIResourcesForUser(userName, permissionRootPath);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.getDeniedRolesForResource(resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.getExplicitlyAllowedUsersForResource(resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.getExplicitlyDeniedUsersForResource(resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.isRoleAuthorized(roleName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        try {
            return this.stub.isUserAuthorized(userName, resourceId, action);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        try {
            this.stub.resetPermissionOnUpdateRole(roleName, newRoleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public int getTenantId() throws UserStoreException {
        return 0;
    }

    private String[] handleException(String msg, Exception e) throws UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new UserStoreException(msg, (Throwable)e);
    }
}

