/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import java.util.Map;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.um.ws.service.dao.RealmConfigurationDTO;
import org.wso2.carbon.um.ws.service.dao.RealmPropertyDTO;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class UserRealmService
extends AbstractAdmin {
    public RealmConfigurationDTO getRealmConfiguration() throws UserStoreException {
        UserRealm userRealm = this.getApplicableUserRealm();
        RealmConfiguration realmConfig = userRealm.getRealmConfiguration();
        RealmConfigurationDTO realmConfigDTO = new RealmConfigurationDTO();
        realmConfigDTO.setRealmClassName(realmConfig.getRealmClassName());
        realmConfigDTO.setUserStoreClass(realmConfig.getUserStoreClass());
        realmConfigDTO.setAuthorizationManagerClass(realmConfig.getAuthorizationManagerClass());
        realmConfigDTO.setAdminRoleName(realmConfig.getAdminRoleName());
        realmConfigDTO.setAdminUserName(realmConfig.getAdminUserName());
        realmConfigDTO.setAdminPassword(realmConfig.getAdminPassword());
        realmConfigDTO.setEveryOneRoleName(realmConfig.getEveryOneRoleName());
        realmConfigDTO.setUserStoreProperties(this.getPropertyValueArray(realmConfig.getUserStoreProperties()));
        realmConfigDTO.setAuthzProperties(this.getPropertyValueArray(realmConfig.getAuthzProperties()));
        realmConfigDTO.setRealmProperties(this.getPropertyValueArray(realmConfig.getRealmProperties()));
        return realmConfigDTO;
    }

    private RealmPropertyDTO[] getPropertyValueArray(Map<String, String> map) {
        RealmPropertyDTO[] realmProps = new RealmPropertyDTO[map.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            realmProps[i] = new RealmPropertyDTO(entry.getKey(), entry.getValue());
            ++i;
        }
        return realmProps;
    }

    private UserRealm getApplicableUserRealm() throws UserStoreException {
        try {
            UserRealm realm = super.getUserRealm();
            if (realm == null) {
                throw new UserStoreException("UserRealm is null");
            }
            return realm;
        }
        catch (Exception e) {
            throw new UserStoreException((Throwable)e);
        }
    }
}

