/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.um.ws.api.WSAuthorizationManager;
import org.wso2.carbon.um.ws.api.WSClaimManager;
import org.wso2.carbon.um.ws.api.WSProfileConfigurationManager;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.WSUserStoreManager;
import org.wso2.carbon.um.ws.api.internal.UserMgtWSAPIDSComponent;
import org.wso2.carbon.um.ws.api.stub.RealmConfigurationDTO;
import org.wso2.carbon.um.ws.api.stub.RemoteUserRealmServiceStub;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class WSRealm
implements UserRealm {
    private static Log log = LogFactory.getLog(WSRealm.class);
    private RealmConfiguration realmConfig = null;
    private WSUserStoreManager userStoreMan = null;
    private WSAuthorizationManager authzMan = null;
    private WSClaimManager claimManager = null;
    private WSProfileConfigurationManager profileManager = null;
    private static String sessionCookie = null;
    private int tenantId = -1;
    private RemoteUserRealmServiceStub stub = null;

    public void init(RealmConfiguration configBean, Map<String, Object> properties, int tenantId) throws UserStoreException {
        ConfigurationContext configCtxt = UserMgtWSAPIDSComponent.getCcServiceInstance().getClientConfigContext();
        this.init(configBean, configCtxt);
    }

    public void init(RealmConfiguration configBean, Map<String, ClaimMapping> claimMapping, Map<String, ProfileConfiguration> profileConfigs, int tenantId) throws UserStoreException {
        ConfigurationContext configCtxt = UserMgtWSAPIDSComponent.getCcServiceInstance().getClientConfigContext();
        this.init(configBean, configCtxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(RealmConfiguration configBean, ConfigurationContext configCtxt) throws UserStoreException {
        this.realmConfig = configBean;
        if (sessionCookie == null) {
            Class<WSRealm> clazz = WSRealm.class;
            // MONITORENTER : org.wso2.carbon.um.ws.api.WSRealm.class
            if (sessionCookie == null) {
                this.login();
            }
            // MONITOREXIT : clazz
        }
        if (sessionCookie == null) {
            throw new UserStoreException("Cannot create session for WSRealm");
        }
        this.init(this.realmConfig.getRealmProperty("WSRealmServerUrl"), sessionCookie, configCtxt);
    }

    void init(String url, String cookie, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            this.stub = new RemoteUserRealmServiceStub(configCtxt, url + "RemoteUserRealmService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)this.getSessionCookie());
        }
        catch (AxisFault e) {
            throw new UserStoreException();
        }
        this.userStoreMan = new WSUserStoreManager(url, cookie, configCtxt);
        this.authzMan = new WSAuthorizationManager(url, cookie, configCtxt);
        this.claimManager = new WSClaimManager(url, cookie, configCtxt);
        this.profileManager = new WSProfileConfigurationManager(url, cookie, configCtxt);
    }

    public UserStoreManager getUserStoreManager() throws UserStoreException {
        return this.userStoreMan;
    }

    public AuthorizationManager getAuthorizationManager() throws UserStoreException {
        return this.authzMan;
    }

    public ClaimManager getClaimManager() throws UserStoreException {
        return this.claimManager;
    }

    public ProfileConfigurationManager getProfileConfigurationManager() throws UserStoreException {
        return this.profileManager;
    }

    public RealmConfiguration getRealmConfiguration() throws UserStoreException {
        try {
            RealmConfigurationDTO realmConfig = this.stub.getRealmConfiguration();
            return WSRealmUtil.convertToRealmConfiguration(realmConfig);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException("Error getting realm config", (Throwable)e);
        }
    }

    public void cleanUp() throws UserStoreException {
        throw new UserStoreException((Throwable)new UnsupportedOperationException("Not implemented"));
    }

    public void login() throws UserStoreException {
        String userName = this.realmConfig.getRealmProperty("WSRealmUserName");
        String password = this.realmConfig.getRealmProperty("WSRealmPassword");
        try {
            ConfigurationContext configContext = UserMgtWSAPIDSComponent.getCcServiceInstance().getClientConfigContext();
            AuthenticationAdminClient client = new AuthenticationAdminClient(configContext, this.realmConfig.getRealmProperty("WSRealmServerUrl"), sessionCookie, null, false);
            boolean isLogin = client.login(userName, password, "127.0.0.1");
            if (isLogin) {
                sessionCookie = client.getAdminCookie();
            }
        }
        catch (Exception e) {
            throw new UserStoreException("Error" + e.getMessage(), (Throwable)e);
        }
    }

    public void lastAccess() {
    }

    public String getSessionCookie() {
        return sessionCookie;
    }

    protected int getTenantId() {
        return this.tenantId;
    }
}

