/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.util.Date;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.Permission;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceStub;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class WSUserStoreManager
implements UserStoreManager {
    private RemoteUserStoreManagerServiceStub stub = null;
    private static Log log = LogFactory.getLog(WSUserStoreManager.class);

    public WSUserStoreManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            this.stub = new RemoteUserStoreManagerServiceStub(configCtxt, serverUrl + "RemoteUserStoreManagerService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        try {
            if (!(credential instanceof String)) {
                throw new UserStoreException("Unsupported type of password");
            }
            String password = (String)credential;
            ClaimValue[] claimValues = WSRealmUtil.convertMapToClaimValue(claims);
            this.stub.addUser(userName, password, roleList, claimValues, profileName, requirePasswordChange);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.core.Permission[] permissions) throws UserStoreException {
        try {
            this.stub.addRole(roleName, userList, this.convertPermission(permissions));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        if (!(credential instanceof String)) {
            throw new UserStoreException("Unsupported type of password");
        }
        try {
            this.stub.addUser(userName, (String)credential, roleList, WSRealmUtil.convertMapToClaimValue(claims), profileName, false);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public boolean authenticate(String userName, Object credential) throws UserStoreException {
        if (!(credential instanceof String)) {
            throw new UserStoreException("Unsupported type of password");
        }
        try {
            return this.stub.authenticate(userName, (String)credential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public void deleteRole(String roleName) throws UserStoreException {
        try {
            this.stub.deleteRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName) throws UserStoreException {
        try {
            this.stub.deleteUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        try {
            this.stub.deleteUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        try {
            this.stub.deleteUserClaimValues(userName, claims, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public String[] getAllProfileNames() throws UserStoreException {
        try {
            return this.stub.getAllProfileNames();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getHybridRoles() throws UserStoreException {
        try {
            return this.stub.getHybridRoles();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public Date getPasswordExpirationTime(String username) throws UserStoreException {
        try {
            long time = this.stub.getPasswordExpirationTime(username);
            if (time != -1L) {
                return new Date(time);
            }
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return null;
    }

    public String[] getProfileNames(String userName) throws UserStoreException {
        try {
            return this.stub.getProfileNames(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        try {
            return this.stub.getRoleListOfUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] getRoleNames() throws UserStoreException {
        try {
            return this.stub.getRoleNames();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public int getTenantId() throws UserStoreException {
        try {
            return this.stub.getTenantId();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public int getTenantId(String username) throws UserStoreException {
        try {
            return this.stub.getTenantIdofUser(username);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        try {
            return this.stub.getUserClaimValue(userName, claim, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return profileName;
        }
    }

    public Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getUserClaimValues(userName, profileName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public Map<String, String> getUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        return null;
    }

    public int getUserId(String username) throws UserStoreException {
        try {
            return this.stub.getUserId(username);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        try {
            return this.stub.getUserListOfRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        try {
            return this.stub.isExistingRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean isExistingUser(String userName) throws UserStoreException {
        try {
            return this.stub.isExistingUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean isReadOnly() throws UserStoreException {
        try {
            return this.stub.isReadOnly();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        try {
            return this.stub.listUsers(filter, maxItemLimit);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            this.stub.setUserClaimValue(userName, claimURI, claimValue, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void setUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        try {
            this.stub.setUserClaimValues(userName, WSRealmUtil.convertMapToClaimValue(claims), profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        if (!(newCredential instanceof String) || !(oldCredential instanceof String)) {
            throw new UserStoreException("Unsupported type of password");
        }
        try {
            this.stub.updateCredential(userName, (String)newCredential, (String)oldCredential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        if (!(newCredential instanceof String)) {
            throw new UserStoreException("Unsupported type of password");
        }
        try {
            this.stub.updateCredentialByAdmin(userName, (String)newCredential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        try {
            this.stub.updateRoleListOfUser(userName, deletedRoles, newRoles);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        try {
            this.stub.updateUserListOfRole(roleName, deletedUsers, newUsers);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        try {
            this.stub.updateRoleName(roleName, newRoleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public boolean isMultipleProfilesAllowed() {
        return true;
    }

    private Permission[] convertPermission(org.wso2.carbon.user.core.Permission[] permissions) {
        if (permissions == null) {
            return null;
        }
        Permission[] perms = new Permission[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            perms[i] = new Permission();
            perms[i].setAction(permissions[i].getAction());
            perms[i].setResourceId(permissions[i].getResourceId());
        }
        return perms;
    }

    private String[] handleException(String msg, Exception e) throws UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new UserStoreException(msg, (Throwable)e);
    }

    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return null;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws UserStoreException {
        this.addRole(roleName, userList, (org.wso2.carbon.user.core.Permission[])org.wso2.carbon.user.core.Permission[].class.cast(permissions));
    }

    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)org.wso2.carbon.user.core.tenant.Tenant.class.cast(tenant));
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        return false;
    }

    public boolean isBulkImportSupported() throws UserStoreException {
        return false;
    }

    public String[] getUserList(String claim, String claimValue, String profileName) throws UserStoreException {
        return new String[0];
    }
}

