/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.stub.ClaimMapping;
import org.wso2.carbon.um.ws.api.stub.RemoteClaimManagerServiceStub;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;

public class WSClaimManager
implements ClaimManager {
    private RemoteClaimManagerServiceStub stub = null;
    private static Log log = LogFactory.getLog(WSClaimManager.class);

    public WSClaimManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            this.stub = new RemoteClaimManagerServiceStub(configCtxt, serverUrl + "RemoteClaimManagerService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            throw new UserStoreException();
        }
    }

    public void addNewClaimMapping(org.wso2.carbon.user.core.claim.ClaimMapping mapping) throws UserStoreException {
        try {
            ClaimMapping claimMapping = WSRealmUtil.convertToADBClaimMapping(mapping);
            this.stub.addNewClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteClaimMapping(org.wso2.carbon.user.core.claim.ClaimMapping mapping) throws UserStoreException {
        try {
            ClaimMapping claimMapping = WSRealmUtil.convertToADBClaimMapping(mapping);
            this.stub.deleteClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public Claim[] getAllClaims() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getAllClaims(null));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new Claim[0];
        }
    }

    public Claim[] getAllClaims(String dialectUri) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getAllClaims(dialectUri));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new Claim[0];
        }
    }

    public String[] getAllClaimUris() throws UserStoreException {
        try {
            return this.stub.getAllClaimUris();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public Claim[] getAllRequiredClaims() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getAllRequiredClaims());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new Claim[0];
        }
    }

    public Claim[] getAllSupportClaimsByDefault() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getAllSupportClaimsByDefault());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new Claim[0];
        }
    }

    public String getAttributeName(String claimURI) throws UserStoreException {
        try {
            return this.stub.getAttributeName(claimURI);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public Claim getClaim(String claimURI) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaim(this.stub.getClaim(claimURI));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public org.wso2.carbon.user.core.claim.ClaimMapping getClaimMapping(String claimURI) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMapping(this.stub.getClaimMapping(claimURI));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void updateClaimMapping(org.wso2.carbon.user.core.claim.ClaimMapping mapping) throws UserStoreException {
        try {
            this.stub.updateClaimMapping(WSRealmUtil.convertToADBClaimMapping(mapping));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    private String[] handleException(String msg, Exception e) throws UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new UserStoreException(msg, (Throwable)e);
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.addNewClaimMapping((org.wso2.carbon.user.core.claim.ClaimMapping)org.wso2.carbon.user.core.claim.ClaimMapping.class.cast(mapping));
    }

    public void deleteClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.deleteClaimMapping((org.wso2.carbon.user.core.claim.ClaimMapping)org.wso2.carbon.user.core.claim.ClaimMapping.class.cast(mapping));
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.updateClaimMapping((org.wso2.carbon.user.core.claim.ClaimMapping)org.wso2.carbon.user.core.claim.ClaimMapping.class.cast(mapping));
    }
}

