/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports.fileupload;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Element;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.ui.transports.fileupload.AnyFileUploadExecutor;

public class FileUploadExecutorManager {
    private static Log log = LogFactory.getLog(FileUploadExecutorManager.class);
    private Map<String, AbstractFileUploadExecutor> executorMap = new HashMap<String, AbstractFileUploadExecutor>();
    private BundleContext bundleContext;
    private ConfigurationContext configContext;
    private String webContext;

    public FileUploadExecutorManager(BundleContext bundleContext, ConfigurationContext configCtx, String webContext) throws CarbonException {
        this.bundleContext = bundleContext;
        this.configContext = configCtx;
        this.webContext = webContext;
        this.loadExecutorMap();
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        request.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
        request.setAttribute("WebContext", (Object)this.webContext);
        request.setAttribute("ServerURL", (Object)CarbonUIUtil.getServerURL(request.getSession().getServletContext(), request.getSession()));
        String requestURI = request.getRequestURI();
        int indexToSplit = requestURI.indexOf("fileupload/") + "fileupload/".length();
        String actionString = requestURI.substring(indexToSplit);
        FileUploadExecutionHandlerManager execHandlerManager = new FileUploadExecutionHandlerManager();
        CarbonXmlFileUploadExecHandler carbonXmlExecHandler = new CarbonXmlFileUploadExecHandler(request, response, actionString);
        execHandlerManager.addExecHandler(carbonXmlExecHandler);
        OSGiFileUploadExecHandler osgiExecHandler = new OSGiFileUploadExecHandler(request, response);
        execHandlerManager.addExecHandler(osgiExecHandler);
        AnyFileUploadExecHandler anyFileExecHandler = new AnyFileUploadExecHandler(request, response);
        execHandlerManager.addExecHandler(anyFileExecHandler);
        execHandlerManager.startExec();
        return true;
    }

    private void loadExecutorMap() throws CarbonException {
        OMElement documentElement;
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        try {
            documentElement = XMLUtils.toOM((Element)serverConfiguration.getDocumentElement());
        }
        catch (Exception e) {
            String msg = "Unable to read Server Configuration.";
            log.error((Object)msg);
            throw new CarbonException(msg, (Throwable)e);
        }
        OMElement fileUploadConfigElement = documentElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "FileUploadConfig"));
        Iterator iterator = fileUploadConfigElement.getChildElements();
        while (iterator.hasNext()) {
            String msg;
            AbstractFileUploadExecutor object;
            OMElement mapppingElement = (OMElement)iterator.next();
            if (!mapppingElement.getLocalName().equalsIgnoreCase("Mapping")) continue;
            OMElement actionsElement = mapppingElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Actions"));
            if (actionsElement == null) {
                String msg2 = "The mandatory FileUploadConfig/Actions entry does not exist or is empty in the CARBON_HOME/conf/carbon.xml file. Please fix this error in the  carbon.xml file and restart.";
                log.error((Object)msg2);
                throw new CarbonException(msg2);
            }
            Iterator actionElementIterator = actionsElement.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Action"));
            if (!actionElementIterator.hasNext()) {
                String msg3 = "A FileUploadConfig/Mapping entry in the CARBON_HOME/conf/carbon.xml should have at least on Action defined. Please fix this error in the carbon.xml file and restart.";
                log.error((Object)msg3);
                throw new CarbonException(msg3);
            }
            OMElement classElement = mapppingElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Class"));
            if (classElement == null || classElement.getText() == null) {
                String msg4 = "The mandatory FileUploadConfig/Mapping/Class entry does not exist or is empty in the CARBON_HOME/conf/carbon.xml file. Please fix this error in the  carbon.xml file and restart.";
                log.error((Object)msg4);
                throw new CarbonException(msg4);
            }
            String className = classElement.getText().trim();
            try {
                Class clazz = this.bundleContext.getBundle().loadClass(className);
                Constructor constructor = clazz.getConstructor(new Class[0]);
                object = (AbstractFileUploadExecutor)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                msg = "Error occurred while trying to instantiate the " + className + " class specified as a FileUploadConfig/Mapping/class element in " + "the CARBON_HOME/conf/carbon.xml file. Please fix this error in " + "the carbon.xml file and restart.";
                log.error((Object)msg, (Throwable)e);
                throw new CarbonException(msg, (Throwable)e);
            }
            while (actionElementIterator.hasNext()) {
                OMElement actionElement = (OMElement)actionElementIterator.next();
                if (actionElement.getText() == null) {
                    msg = "A FileUploadConfig/Mapping/Actions/Action element in the CARBON_HOME/conf/carbon.xml file is empty. Please include the correct value in this file and restart.";
                    log.error((Object)msg);
                    throw new CarbonException(msg);
                }
                this.executorMap.put(actionElement.getText().trim(), object);
            }
        }
    }

    public void addExecutor(String action, String executorClass) throws CarbonException {
        String msg;
        if (action == null) {
            msg = "A FileUploadConfig/Mapping/Actions/Action element is null ";
            log.error((Object)msg);
        }
        if (executorClass == null || executorClass.equals("")) {
            msg = "Provided FileUploadExecutor object is invalid ";
            log.error((Object)msg);
        }
        try {
            Class clazz = this.bundleContext.getBundle().loadClass(executorClass);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            AbstractFileUploadExecutor object = (AbstractFileUploadExecutor)constructor.newInstance(new Object[0]);
            this.executorMap.put(action, object);
        }
        catch (Exception e) {
            String msg2 = "Error occurred while trying to instantiate the " + executorClass + " class specified as a FileUploadConfig/Mapping/class element";
            log.error((Object)msg2, (Throwable)e);
            throw new CarbonException(msg2, (Throwable)e);
        }
    }

    public void removeExecutor(String action) {
        if (action == null) {
            String msg = "A FileUploadConfig/Mapping/Actions/Action element is null ";
            log.error((Object)msg);
        }
        this.executorMap.remove(action);
    }

    private class CarbonXmlFileUploadExecHandler
    extends FileUploadExecutionHandler {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private String actionString;

        private CarbonXmlFileUploadExecHandler(HttpServletRequest request, HttpServletResponse response, String actionString) {
            this.request = request;
            this.response = response;
            this.actionString = actionString;
        }

        @Override
        public void execute() throws IOException {
            boolean foundExecutor = false;
            for (String key : FileUploadExecutorManager.this.executorMap.keySet()) {
                if (!key.equals(this.actionString)) continue;
                AbstractFileUploadExecutor obj = (AbstractFileUploadExecutor)FileUploadExecutorManager.this.executorMap.get(key);
                foundExecutor = true;
                obj.executeGeneric(this.request, this.response, FileUploadExecutorManager.this.configContext);
                break;
            }
            if (!foundExecutor) {
                this.next();
            }
        }
    }

    private class OSGiFileUploadExecHandler
    extends FileUploadExecutionHandler {
        private HttpServletRequest request;
        private HttpServletResponse response;

        private OSGiFileUploadExecHandler(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public void execute() throws IOException {
            ServiceReference[] serviceReferences;
            try {
                serviceReferences = FileUploadExecutorManager.this.bundleContext.getServiceReferences(AbstractFileUploadExecutor.class.getName(), null);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Service reference cannot be obtained", e);
            }
            boolean foundExecutor = false;
            if (serviceReferences != null) {
                String requestURI = this.request.getRequestURI();
                for (ServiceReference reference : serviceReferences) {
                    String action = (String)reference.getProperty("action");
                    if (action == null || requestURI.indexOf(action) <= -1) continue;
                    foundExecutor = true;
                    AbstractFileUploadExecutor uploadExecutor = (AbstractFileUploadExecutor)FileUploadExecutorManager.this.bundleContext.getService(reference);
                    uploadExecutor.executeGeneric(this.request, this.response, FileUploadExecutorManager.this.configContext);
                    break;
                }
                if (!foundExecutor) {
                    this.next();
                }
            }
        }
    }

    private class AnyFileUploadExecHandler
    extends FileUploadExecutionHandler {
        private HttpServletRequest request;
        private HttpServletResponse response;

        private AnyFileUploadExecHandler(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public void execute() throws IOException {
            Object obj = FileUploadExecutorManager.this.executorMap.get("*");
            if (obj == null) {
                log.warn((Object)"Reached 'All' section but Could not find the Implementation Class");
                return;
            }
            AnyFileUploadExecutor executor = (AnyFileUploadExecutor)obj;
            executor.executeGeneric(this.request, this.response, FileUploadExecutorManager.this.configContext);
        }
    }

    private abstract class FileUploadExecutionHandler {
        private FileUploadExecutionHandler next;

        private FileUploadExecutionHandler() {
        }

        public abstract void execute() throws IOException;

        public final void next() throws IOException {
            this.next.execute();
        }

        public final void setNext(FileUploadExecutionHandler next) {
            this.next = next;
        }
    }

    private static class FileUploadExecutionHandlerManager {
        private FileUploadExecutionHandler firstHandler;
        private FileUploadExecutionHandler prevHandler;

        private FileUploadExecutionHandlerManager() {
        }

        public void addExecHandler(FileUploadExecutionHandler handler) {
            if (this.prevHandler != null) {
                this.prevHandler.setNext(handler);
            } else {
                this.firstHandler = handler;
            }
            this.prevHandler = handler;
        }

        public void startExec() throws IOException {
            this.firstHandler.execute();
        }
    }
}

