/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.clients;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;

public class LoggedUserInfoClient {
    private static final Log log = LogFactory.getLog(LoggedUserInfoClient.class);
    private LoggedUserInfoAdminStub stub;

    public LoggedUserInfoClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceEPR = serverURL + "LoggedUserInfoAdmin";
        this.stub = new LoggedUserInfoAdminStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        if (cookie != null) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public org.wso2.carbon.core.common.LoggedUserInfo getUserInfo() throws Exception {
        try {
            return this.getLoggedUserInfo(this.stub.getUserInfo());
        }
        catch (Exception e) {
            String msg = "Error occurred while getting system permissions of user";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    private org.wso2.carbon.core.common.LoggedUserInfo getLoggedUserInfo(LoggedUserInfo userInfo) {
        org.wso2.carbon.core.common.LoggedUserInfo loggedUserInfo = new org.wso2.carbon.core.common.LoggedUserInfo();
        loggedUserInfo.setUIPermissionOfUser(userInfo.getUIPermissionOfUser());
        loggedUserInfo.setPasswordExpiration(userInfo.getPasswordExpiration());
        return loggedUserInfo;
    }
}

