/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyTimerTask
extends TimerTask {
    private AxisConfiguration axisConfig;
    private static Log log = LogFactory.getLog(ProxyTimerTask.class);

    public ProxyTimerTask(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            try {
                AxisServiceGroup proxyAxisServiceGroup = this.axisConfig.getServiceGroup("TryItMockServiceGroup");
                if (proxyAxisServiceGroup != null) {
                    boolean isLast;
                    ArrayList<String> removeServiceList = new ArrayList<String>();
                    Iterator iterator = proxyAxisServiceGroup.getServices();
                    while (iterator.hasNext()) {
                        AxisService axisServce = (AxisService)iterator.next();
                        Long longTime = (Long)axisServce.getParameterValue("_LAST_TOUCH_TIME_");
                        if (System.currentTimeMillis() - longTime <= 1200000L) continue;
                        removeServiceList.add(axisServce.getName());
                    }
                    if (removeServiceList.size() > 0) {
                        for (String axisServiceName : removeServiceList) {
                            proxyAxisServiceGroup.removeService(axisServiceName);
                        }
                    }
                    if (!(isLast = proxyAxisServiceGroup.getServices().hasNext())) {
                        this.axisConfig.removeServiceGroup("TryItMockServiceGroup");
                    }
                }
            }
            catch (AxisFault axisFault) {
                String msg = "Fault occured when manipulating Tryit proxy service group";
                log.error((Object)msg, (Throwable)axisFault);
            }
        }
    }
}

