/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.wsdl2form.ProxyMessageReceiver;
import org.wso2.carbon.wsdl2form.ProxyTimerTask;
import org.wso2.carbon.wsdl2form.Util;
import org.wso2.carbon.wsdl2form.internal.WSDL2FormServiceComponent;

public class WSDL2FormGenerator {
    public static final String TRYIT_SG_NAME = "TryItMockServiceGroup";
    private static final String PROXY_TIMER = "_PROXY_TIMER_";
    public static final String LAST_TOUCH_TIME = "_LAST_TOUCH_TIME_";
    public static final String SERVICE_NOT_FOUND = "SERVICE_NOT_FOUND";
    public static final String SERVICE_INACTIVE = "SERVICE_INACTIVE";
    public static final String UNSUPPORTED_LANG = "UNSUPPORTED_LANG";
    public static final String SUCCESS = "SUCCESSFULL";
    public static final String SERVICE_QUERY_PARAM = "service";
    public static final String OPERATION_PARAM = "operation";
    public static final String ENDPOINT_QUERY_PARAM = "endpoint";
    public static final String LANGUAGE_QUERY_PARAM = "lang";
    public static final String LOCALHOST_QUERY_PARAM = "localhost";
    public static final String CONTENT_TYPE_QUERY_PARAM = "content-type";
    public static final long PERIOD = 1200000L;
    private static final String PORT = "port";
    private static final WSDL2FormGenerator INSTANCE = new WSDL2FormGenerator();
    private static Log log = LogFactory.getLog(WSDL2FormGenerator.class);

    public static WSDL2FormGenerator getInstance() {
        return INSTANCE;
    }

    public String getInternalTryit(Result result, ConfigurationContext configCtx, String tryitURL, String serviceName, String operationName, String endpointName, boolean fullPage) throws CarbonException {
        try {
            AxisService axisService;
            URL url = new URL(tryitURL);
            String serviceContextRoot = configCtx.getServiceContextPath();
            String contextRoot = WSDL2FormServiceComponent.getServerConfigurationService().getFirstProperty("WebContextRoot");
            if (!serviceContextRoot.endsWith("/")) {
                serviceContextRoot = serviceContextRoot + "/";
            }
            if (!contextRoot.endsWith("/")) {
                contextRoot = contextRoot + "/";
            }
            if ((axisService = this.getAxisService(tryitURL, serviceContextRoot, configCtx)) != null) {
                if (axisService.isActive()) {
                    if (!axisService.isEnableAllTransports() && !axisService.isExposedTransport(url.getProtocol())) {
                        if ("http".equals(url.getProtocol()) && axisService.isExposedTransport("https")) {
                            TransportInDescription httpsTransport = configCtx.getAxisConfiguration().getTransportIn("https");
                            Parameter parameter = httpsTransport.getParameter("proxyPort");
                            String port = "";
                            if (parameter != null && !"-1".equals(parameter.getValue())) {
                                String value = (String)parameter.getValue();
                                if (!"443".equals(value)) {
                                    port = value;
                                }
                            } else {
                                port = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)configCtx, (String)"https"));
                            }
                            String redirectURL = "https://" + url.getHost() + ":" + port + url.getPath() + "?" + url.getQuery();
                            return redirectURL;
                        }
                        if ("https".equals(url.getProtocol()) && axisService.isExposedTransport("http")) {
                            TransportInDescription httpsTransport = configCtx.getAxisConfiguration().getTransportIn("http");
                            Parameter parameter = httpsTransport.getParameter("proxyPort");
                            String port = "";
                            if (parameter != null && !"-1".equals(parameter.getValue())) {
                                String value = (String)parameter.getValue();
                                if (!"80".equals(value)) {
                                    port = value;
                                }
                            } else {
                                port = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)configCtx, (String)"http"));
                            }
                            String redirectURL = "http://" + url.getHost() + ":" + port + url.getPath() + "?" + url.getQuery();
                            return redirectURL;
                        }
                    }
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    DOMSource xmlSource = Util.getSigStream(axisService, null);
                    String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)tryitURL);
                    String multitenantPrefix = contextRoot;
                    if (tenantDomain != null) {
                        multitenantPrefix = contextRoot + "t/" + tenantDomain + "/";
                    }
                    paramMap.put("js-global-params", multitenantPrefix + "carbon/global-params.js");
                    paramMap.put("proxyAddress", contextRoot + "carbon/admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp");
                    paramMap.put("js-service-stub", url.getPath() + "?stub");
                    paramMap.put("services-path", serviceContextRoot);
                    Util.generateTryit(xmlSource, result, paramMap);
                    return SUCCESS;
                }
                throw new CarbonException(SERVICE_INACTIVE);
            }
            throw new CarbonException(SERVICE_NOT_FOUND);
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (OMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    public String getExternalTryit(String tryitWSDL, String serviceName, String operationName, String endpointName, String hostName, boolean fullPage) throws CarbonException {
        Hashtable fileResourcesMap = (Hashtable)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        InputStream inXMLStream = null;
        try {
            AxisEndpoint ep;
            String key;
            String serviceContextRoot;
            WSDL11ToAxisServiceBuilder builder;
            ConfigurationContext configCtx = WSDL2FormServiceComponent.getConfigurationContextService().getServerConfigContext();
            File location = Util.writeWSDLToFileSystemHelpler(tryitWSDL);
            inXMLStream = new FileInputStream(location);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(inXMLStream);
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(streamReader);
            OMElement docEle = stAXOMBuilder.getDocumentElement();
            if (docEle.getQName().getLocalPart().equals("definitions")) {
                builder = new WSDL11ToAxisServiceBuilder((InputStream)new FileInputStream(location));
                builder.setBaseUri(this.getBaseURI(tryitWSDL));
                builder.setAllPorts(true);
            } else if (docEle.getQName().getLocalPart().equals("description")) {
                builder = new WSDL20ToAxisServiceBuilder((InputStream)new FileInputStream(location), null, null);
                builder.setBaseUri(this.getBaseURI(tryitWSDL));
            } else {
                String msg = WSDL2FormGenerator.class.getName() + " standard WSDL document is not found";
                log.error((Object)msg);
                throw new CarbonException(msg);
            }
            AxisService axisService = builder.populateService();
            this.updateMockProxyServiceGroup(axisService, MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration());
            ArrayList<String> exposeTxList = new ArrayList<String>();
            exposeTxList.add("http");
            axisService.setExposedTransports(exposeTxList);
            ByteArrayOutputStream wsdl2Bos = new ByteArrayOutputStream();
            if (hostName == null || hostName.length() == 0) {
                hostName = NetworkUtils.getLocalHostname();
            }
            Map endpointMap = axisService.getEndpoints();
            HashMap<String, String> origUrlMap = new HashMap<String, String>();
            Set endKeySet = endpointMap.keySet();
            TransportInDescription inDescription = configCtx.getAxisConfiguration().getTransportIn("http");
            Parameter proxyParameter = inDescription.getParameter("proxyPort");
            String proxyEndpointPrefix = "http://" + hostName;
            String proxyEndpointPort = ":" + inDescription.getParameter(PORT).getValue();
            if (proxyParameter != null && !"-1".equals(proxyParameter.getValue())) {
                proxyEndpointPort = !"80".equals(proxyParameter.getValue()) ? ":" + proxyParameter.getValue() : "";
            }
            if (!(serviceContextRoot = configCtx.getServiceContextPath()).endsWith("/")) {
                serviceContextRoot = serviceContextRoot + "/";
            }
            String proxyEndpoint = proxyEndpointPrefix + proxyEndpointPort + serviceContextRoot + axisService.getName() + "/";
            for (Object anEndKeySet : endKeySet) {
                key = (String)anEndKeySet;
                ep = (AxisEndpoint)endpointMap.get(key);
                origUrlMap.put(key, ep.getEndpointURL());
                ep.setEndpointURL(proxyEndpoint);
            }
            for (Object anEndKeySet : endKeySet) {
                key = (String)anEndKeySet;
                ep = (AxisEndpoint)endpointMap.get(key);
                ep.setEndpointURL((String)origUrlMap.get(key));
            }
            axisService.printWSDL2((OutputStream)wsdl2Bos, hostName);
            String string = this.generateTryitExternal(axisService, configCtx, wsdl2Bos, serviceName, operationName, endpointName, fileResourcesMap, fullPage, false);
            return string;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (OMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        finally {
            if (inXMLStream != null) {
                try {
                    inXMLStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing I/O streams", (Throwable)e);
                }
            }
        }
    }

    public String getInternalMockit(Result result, ConfigurationContext configCtx, String mockitWSDL, String serviceName, String operationName, String taskID, String proxyUrl, boolean fullPage) throws CarbonException {
        try {
            AxisService axisService;
            URL url = new URL(mockitWSDL);
            String serviceContextRoot = configCtx.getServiceContextPath();
            if (!serviceContextRoot.endsWith("/")) {
                serviceContextRoot = serviceContextRoot + "/";
            }
            if ((axisService = this.getAxisService(mockitWSDL, serviceContextRoot, configCtx)) != null) {
                if (axisService.isActive()) {
                    if (!axisService.isEnableAllTransports() && !axisService.isExposedTransport(url.getProtocol())) {
                        if ("http".equals(url.getProtocol()) && axisService.isExposedTransport("https")) {
                            TransportInDescription httpsTransport = configCtx.getAxisConfiguration().getTransportIn("https");
                            Parameter parameter = httpsTransport.getParameter("proxyPort");
                            String port = "";
                            if (parameter != null && !"-1".equals(parameter.getValue())) {
                                String value = (String)parameter.getValue();
                                if (!"443".equals(value)) {
                                    port = ":" + value;
                                }
                            } else {
                                port = ":" + CarbonUtils.getTransportPort((ConfigurationContext)configCtx, (String)"https");
                            }
                            String redirectURL = "https://" + url.getHost() + ":" + port + url.getPath() + "?" + url.getQuery();
                            return redirectURL;
                        }
                        if ("https".equals(url.getProtocol()) && axisService.isExposedTransport("http")) {
                            TransportInDescription httpsTransport = configCtx.getAxisConfiguration().getTransportIn("http");
                            Parameter parameter = httpsTransport.getParameter("proxyPort");
                            String port = "";
                            if (parameter != null && !"-1".equals(parameter.getValue())) {
                                String value = (String)parameter.getValue();
                                if (!"80".equals(value)) {
                                    port = ":" + value;
                                }
                            } else {
                                port = ":" + CarbonUtils.getTransportPort((ConfigurationContext)configCtx, (String)"http");
                            }
                            String redirectURL = "https://" + url.getHost() + ":" + port + url.getPath() + "?" + url.getQuery();
                            return redirectURL;
                        }
                    }
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    DOMSource xmlSource = Util.getSigStream(axisService, null);
                    paramMap.put("image-path", "?wsdl2form&type=image&resource=");
                    paramMap.put("show-alternate", "false");
                    paramMap.put("fixendpoints", "true");
                    paramMap.put("task-id", taskID);
                    paramMap.put("proxyAddress", proxyUrl);
                    if (serviceName != null && !serviceName.equals("")) {
                        paramMap.put(SERVICE_QUERY_PARAM, serviceName);
                    }
                    if (operationName != null && !operationName.equals("")) {
                        paramMap.put(OPERATION_PARAM, operationName);
                    }
                    if (fullPage) {
                        paramMap.put("full-page", "true");
                    }
                    Util.generateMockit(xmlSource, result, paramMap);
                    return SUCCESS;
                }
                throw new CarbonException(SERVICE_INACTIVE);
            }
            throw new CarbonException(SERVICE_NOT_FOUND);
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (OMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    public String getExternalMockit(Result result, Definition mockitWSDL, QName serviceName, String portName, String operationName, String taskID, String proxyUrl, String baseUrl, boolean fullPage) throws CarbonException {
        try {
            WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(mockitWSDL, serviceName, portName);
            builder.setAllPorts(true);
            AxisService axisService = builder.populateService();
            this.updateMockProxyServiceGroup(axisService, MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            DOMSource xmlSource = Util.getSigStream(axisService, null);
            paramMap.put("image-path", "../../carbon/tryit/images/");
            paramMap.put("show-alternate", "false");
            paramMap.put("fixendpoints", "true");
            paramMap.put("task-id", taskID);
            paramMap.put("proxyAddress", proxyUrl);
            if (serviceName != null && !serviceName.equals("")) {
                paramMap.put(SERVICE_QUERY_PARAM, serviceName.getLocalPart());
            }
            if (operationName != null && !operationName.equals("")) {
                paramMap.put(OPERATION_PARAM, operationName);
            }
            if (fullPage) {
                paramMap.put("full-page", "true");
            }
            Util.generateMockit(xmlSource, result, paramMap);
            return SUCCESS;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (OMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    public String getJSStub(Result result, ConfigurationContext configCtx, String stubURL, String serviceName, String endpointName, String language, String localhost, String contentType) throws CarbonException {
        try {
            AxisService axisService;
            String serviceContextRoot = configCtx.getServiceContextPath();
            if (!serviceContextRoot.endsWith("/")) {
                serviceContextRoot = serviceContextRoot + "/";
            }
            if ((axisService = this.getAxisService(stubURL, serviceContextRoot, configCtx)) != null) {
                if (axisService.isActive()) {
                    String type;
                    DOMSource xmlSource = Util.getSigStream(axisService, null);
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    if (language == null || language.equals("") || language.equalsIgnoreCase("javascript") || language.equalsIgnoreCase("ecmascript") || language.equalsIgnoreCase("js")) {
                        type = "application/javascript";
                    } else if (language.equalsIgnoreCase("e4x")) {
                        parameterMap.put("e4x", "true");
                        type = "text/javascript";
                    } else {
                        throw new CarbonException(UNSUPPORTED_LANG);
                    }
                    if (contentType != null && !"".equals(contentType.trim())) {
                        type = contentType;
                    }
                    type = type + "; charset=utf-8";
                    if (localhost != null && "true".equals(localhost)) {
                        parameterMap.put("localhost-endpoints", "true");
                    }
                    Util.generateStub(xmlSource, result, parameterMap);
                    return type;
                }
                throw new CarbonException(SERVICE_INACTIVE);
            }
            throw new CarbonException(SERVICE_NOT_FOUND);
        }
        catch (OMException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    private String generateTryitExternal(AxisService service, ConfigurationContext configCtx, ByteArrayOutputStream wsdl2Bos, String serviceName, String operationName, String endpointName, Map fileResourcesMap, boolean fullPage, boolean needSOAPAction) throws ParserConfigurationException, TransformerException, FileNotFoundException, CarbonException {
        String serviceContextRoot;
        if (log.isDebugEnabled()) {
            try {
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(wsdl2Bos.toByteArray()));
                StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(streamReader);
                OMElement ele = stAXOMBuilder.getDocumentElement();
                log.debug((Object)("output ==> " + ele.toString()));
            }
            catch (XMLStreamException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!(serviceContextRoot = configCtx.getServiceContextPath()).endsWith("/")) {
            serviceContextRoot = serviceContextRoot + "/";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DOMSource xmlSource = Util.getSigStream(service, wsdl2Bos, null);
        Util.FileInfo jsFileLocation = Util.getOutputFileLocation(".stub.js");
        File jsFile = jsFileLocation.getFile();
        FileOutputStream jsStubOutputStream = new FileOutputStream(jsFile);
        StreamResult jsStubResult = new StreamResult(jsStubOutputStream);
        Util.generateStub(xmlSource, jsStubResult, null);
        File[] files0 = jsFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".stub.js");
            }
        });
        if (files0 != null && files0[0] != null && files0[0].getAbsoluteFile() != null) {
            String absolutePath = files0[0].getAbsoluteFile().getAbsolutePath();
            fileResourcesMap.put(jsFileLocation.getUuid(), absolutePath);
        }
        Util.FileInfo htmlFileLocation = Util.getOutputFileLocation(".html");
        File tryItOutFile = htmlFileLocation.getFile();
        FileOutputStream tryItOutFileStream = new FileOutputStream(tryItOutFile);
        StreamResult tryItResult = new StreamResult(tryItOutFileStream);
        paramMap.put("js-global-params", "carbon/global-params.js");
        paramMap.put("proxyAddress", "carbon/admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp");
        paramMap.put("js-service-stub", "filedownload?id=" + jsFileLocation.getUuid());
        paramMap.put("js-WSRequest", "carbon/admin/js/WSRequest.js");
        paramMap.put("js-jQuery", "carbon/admin/js/jquery-1.5.2.min.js");
        paramMap.put("js-jQueryUI", "carbon/admin/js/jquery-ui-1.8.11.custom.min.js");
        paramMap.put("js-corners", "carbon/tryit/extras/jquery.corner.js");
        paramMap.put("js-editArea", "carbon/editarea/edit_area_full.js");
        paramMap.put("xslt-location", "carbon/tryit/xslt/prettyprinter.xslt");
        paramMap.put("css-images", "carbon/tryit/images/");
        paramMap.put("css-jQueryUI", "carbon/admin/css/smoothness/jquery-ui-1.8.11.custom.css");
        paramMap.put("show-alternate", "false");
        paramMap.put("fixendpoints", "true");
        Util.generateTryit(xmlSource, tryItResult, paramMap);
        File[] files1 = tryItOutFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".html");
            }
        });
        if (files1 != null && files1[0] != null && files1[0].getAbsoluteFile() != null) {
            fileResourcesMap.put(htmlFileLocation.getUuid(), files1[0].getAbsoluteFile().getAbsolutePath());
        }
        return serviceContextRoot + ".." + "/filedownload" + "?id=" + htmlFileLocation.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMockProxyServiceGroup(AxisService axisService, AxisConfiguration axisConfig) throws AxisFault {
        ProxyMessageReceiver receiver = new ProxyMessageReceiver();
        PhasesInfo phaseInfo = axisConfig.getPhasesInfo();
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation op = (AxisOperation)i.next();
            op.setMessageReceiver((MessageReceiver)receiver);
            phaseInfo.setOperationPhases(op);
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            AxisService testService;
            AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(TRYIT_SG_NAME);
            if (serviceGroup == null) {
                serviceGroup = new AxisServiceGroup();
                serviceGroup.setServiceGroupName(TRYIT_SG_NAME);
                serviceGroup.addParameter("DoAuthentication", (Object)"false");
                serviceGroup.addParameter("adminService", (Object)"true");
            }
            if ((testService = axisConfig.getService(axisService.getName())) != null) {
                int loop = 1;
                while (true) {
                    String testName;
                    if (axisConfig.getService(testName = axisService.getName() + "_" + loop) == null) {
                        axisService.setName(testName);
                        break;
                    }
                    ++loop;
                }
            }
            serviceGroup.addService(axisService);
            axisConfig.addServiceGroup(serviceGroup);
            axisService.addParameter(LAST_TOUCH_TIME, (Object)System.currentTimeMillis());
            axisService.addParameter("modifyUserWSDLPortAddress", (Object)"false");
            Parameter parameter = axisConfig.getParameter(PROXY_TIMER);
            if (parameter == null) {
                Timer timer = new Timer();
                timer.scheduleAtFixedRate((TimerTask)new ProxyTimerTask(axisConfig), 1200000L, 1200000L);
                parameter = new Parameter(PROXY_TIMER, (Object)timer);
                axisConfig.addParameter(parameter);
            }
        }
    }

    private String getBaseURI(String currentURI) {
        String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
        return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
    }

    private AxisService getAxisService(String url, String serviceContextRoot, ConfigurationContext configCtx) throws AxisFault {
        String service = url.substring(url.indexOf(serviceContextRoot) + serviceContextRoot.length(), url.indexOf("?"));
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        AxisService axisService = axisConfig.getServiceForActivation(service);
        if (axisService == null) {
            axisService = TenantAxisUtils.getAxisService((String)url, (ConfigurationContext)configCtx);
            axisConfig = TenantAxisUtils.getTenantAxisConfiguration((String)TenantAxisUtils.getTenantDomain((String)url), (ConfigurationContext)configCtx);
        }
        if (GhostDeployerUtils.isGhostService((AxisService)axisService) && axisConfig != null) {
            axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)axisConfig, (AxisService)axisService);
        }
        return axisService;
    }
}

