/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.bapi.util;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.bapi.util.RFCConstants;

public class RFCMetaDataParser {
    private static Log log = LogFactory.getLog(RFCMetaDataParser.class);

    public static void processMetaDataDocument(OMElement document, JCoFunction function) throws AxisFault {
        Iterator itr = document.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            RFCMetaDataParser.processElement(childElement, function);
        }
    }

    public static String getBAPIRFCFucntionName(OMElement rootElement) throws AxisFault {
        String qname = rootElement.getQName().toString();
        if (qname != null) {
            if (qname.equals("bapirfc")) {
                String rfcFunctionName = rootElement.getAttributeValue(RFCConstants.NAME_Q);
                if (rfcFunctionName != null) {
                    return rfcFunctionName;
                }
                throw new AxisFault("BAPI/RFC function name is mandatory in meta data configuration");
            }
            throw new AxisFault("Invalid meta data root element.Found: " + qname + "" + ". Required:" + "bapirfc");
        }
        return null;
    }

    private static void processElement(OMElement element, JCoFunction function) throws AxisFault {
        String qname = element.getQName().toString();
        if (qname != null) {
            if (qname.equals("import")) {
                RFCMetaDataParser.processImport(element, function);
            } else if (qname.equals("tables")) {
                RFCMetaDataParser.processTables(element, function);
            } else {
                log.warn((Object)("Unknown meta data type tag :" + qname + " detected. " + "This meta data element will be discarded!"));
            }
        }
    }

    private static void processImport(OMElement element, JCoFunction function) throws AxisFault {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String name = childElement.getAttributeValue(RFCConstants.NAME_Q);
            if (qname.equals("structure")) {
                RFCMetaDataParser.processStructure(childElement, function, name);
                continue;
            }
            if (qname.equals("field")) {
                RFCMetaDataParser.processField(childElement, function, name);
                continue;
            }
            log.warn((Object)("Unknown meta data type tag :" + qname + " detected. " + "This meta data element will be discarded!"));
        }
    }

    private static void processStructure(OMElement element, JCoFunction function, String strcutName) throws AxisFault {
        if (strcutName == null) {
            throw new AxisFault("A structure should have a name!");
        }
        JCoStructure jcoStrcture = function.getImportParameterList().getStructure(strcutName);
        if (jcoStrcture != null) {
            Iterator itr = element.getChildElements();
            boolean isRecordFound = false;
            while (itr.hasNext()) {
                OMElement childElement = (OMElement)itr.next();
                String qname = childElement.getQName().toString();
                if (qname.equals("field")) {
                    String fieldName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    String fieldValue = childElement.getText();
                    for (JCoField field : jcoStrcture) {
                        if (fieldName == null || !fieldName.equals(field.getName())) continue;
                        isRecordFound = true;
                        field.setValue(fieldValue);
                        break;
                    }
                    if (isRecordFound) continue;
                    throw new AxisFault("Invalid configuration! The field : " + fieldName + "" + " did not find the the strcture : " + strcutName);
                }
                log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data " + "type will be ignored"));
            }
        } else {
            log.error((Object)("Didn't find the specified structure : " + strcutName + " on the RFC" + " repository. This structure will be ignored"));
        }
    }

    private static void processField(OMElement element, JCoFunction function, String fieldName) throws AxisFault {
        if (fieldName == null) {
            throw new AxisFault("A field should have a name!");
        }
        String fieldValue = element.getText();
        if (fieldValue != null) {
            function.getImportParameterList().setValue(fieldName, fieldValue);
        }
    }

    private static void processTables(OMElement element, JCoFunction function) throws AxisFault {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String tableName = childElement.getAttributeValue(RFCConstants.NAME_Q);
            if (qname.equals("table")) {
                RFCMetaDataParser.processTable(childElement, function, tableName);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data " + "type will be ignored"));
        }
    }

    private static void processTable(OMElement element, JCoFunction function, String tableName) throws AxisFault {
        JCoTable inputTable = function.getTableParameterList().getTable(tableName);
        if (inputTable == null) {
            throw new AxisFault("Input table :" + tableName + " does not exist");
        }
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String id = childElement.getAttributeValue(RFCConstants.ID_Q);
            if (qname.equals("row")) {
                RFCMetaDataParser.processRow(childElement, inputTable, id);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data " + "type will be ignored"));
        }
    }

    private static void processRow(OMElement element, JCoTable table, String id) throws AxisFault {
        for (int i = 0; i < table.getNumRows(); ++i) {
            if (Integer.parseInt(id) != i) continue;
            table.setRow(i);
            Iterator itr = element.getChildElements();
            while (itr.hasNext()) {
                OMElement childElement = (OMElement)itr.next();
                String qname = childElement.getQName().toString();
                if (qname != null && qname.equals("field")) {
                    RFCMetaDataParser.processField(childElement, table);
                    continue;
                }
                log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data " + "type will be ignored"));
            }
        }
    }

    private static void processField(OMElement element, JCoTable table) throws AxisFault {
        String fieldName = element.getAttributeValue(RFCConstants.NAME_Q);
        String fieldValue = element.getText();
        if (fieldName == null) {
            throw new AxisFault("A field should have a name!");
        }
        if (fieldValue != null) {
            table.setValue(fieldName, fieldValue);
        }
    }
}

