/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.bapi;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.bapi.BAPIEndpoint;

public class Axis2RFCHandler
implements JCoServerFunctionHandler {
    private static final Log log = LogFactory.getLog(Axis2RFCHandler.class);
    private WorkerPool workerPool;
    private BAPIEndpoint endpoint;

    public Axis2RFCHandler(BAPIEndpoint endpoint, WorkerPool workerPool) {
        this.endpoint = endpoint;
        this.workerPool = workerPool;
    }

    public void handleRequest(JCoServerContext jCoServerContext, JCoFunction jCoFunction) throws AbapException, AbapClassException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New BAPI function call received");
        }
        this.workerPool.execute((Runnable)new BAPIWorker(jCoServerContext, jCoFunction));
    }

    private class BAPIWorker
    implements Runnable {
        private JCoServerContext serverContext;
        private JCoFunction function;

        public BAPIWorker(JCoServerContext serverContext, JCoFunction function) {
            this.serverContext = serverContext;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a new BAPI worker thread to process the incoming request");
            }
            String xml = this.function.toXML();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            try {
                MessageContext msgContext = Axis2RFCHandler.this.endpoint.createMessageContext();
                msgContext.setIncomingTransportName("bapi");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating SOAP envelope from the BAPI function call");
                }
                SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)bais, (String)"application/xml");
                msgContext.setEnvelope(envelope);
                AxisEngine.receive((MessageContext)msgContext);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing the BAPI call through the Axis engine", (Throwable)e);
            }
            finally {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the stream", (Throwable)e);
                }
            }
        }
    }
}

