/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap;

import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.DefaultErrorListener;
import org.wso2.carbon.transports.sap.DefaultTIDHandler;

public abstract class SAPEndpoint
extends ProtocolEndpoint {
    protected static Log log;
    protected String serverName;
    protected boolean errorListenerEnabled;
    protected boolean tidHandlerEnabled;
    protected int connections;
    protected String customErrorListener;
    protected String customExceptionListener;
    protected String customTIDHandler;

    public SAPEndpoint() {
        log = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public EndpointReference[] getEndpointReferences(AxisService service, String ip) throws AxisFault {
        return null;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        if (!(params instanceof AxisService)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading configuration for the SAP endpoint");
        }
        this.serverName = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.serverName");
        if (this.serverName == null) {
            return false;
        }
        this.connections = ParamUtils.getOptionalParamInt((ParameterInclude)params, (String)"transport.sap.connections", (int)1);
        this.errorListenerEnabled = "enabled".equals(ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.enableErrorListener"));
        this.tidHandlerEnabled = "enabled".equals(ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.enableTIDHandler"));
        this.customErrorListener = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.customErrorListener");
        this.customExceptionListener = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.customExceptionListener");
        this.customTIDHandler = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.sap.customTIDHandler");
        return true;
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    protected void setupOptionalFeatures(JCoServer server) throws Exception {
        Class<?> clazz;
        server.setConnectionCount(this.connections);
        if (this.errorListenerEnabled) {
            DefaultErrorListener errorListener = new DefaultErrorListener();
            if (this.customErrorListener == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Engaging the default error listener for : " + this.serverName));
                }
                server.addServerErrorListener((JCoServerErrorListener)errorListener);
            }
            if (this.customExceptionListener == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Engaging the default exception listener for : " + this.serverName));
                }
                server.addServerExceptionListener((JCoServerExceptionListener)errorListener);
            }
        }
        if (this.tidHandlerEnabled && this.customTIDHandler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Engaging the default TID handler for : " + this.serverName));
            }
            server.setTIDHandler((JCoServerTIDHandler)new DefaultTIDHandler());
        }
        if (this.customErrorListener != null) {
            clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.customErrorListener);
            server.addServerErrorListener((JCoServerErrorListener)clazz.newInstance());
        }
        if (this.customExceptionListener != null) {
            clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.customExceptionListener);
            server.addServerExceptionListener((JCoServerExceptionListener)clazz.newInstance());
        }
        if (this.customTIDHandler != null) {
            clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.customTIDHandler);
            server.setTIDHandler((JCoServerTIDHandler)clazz.newInstance());
        }
    }

    public abstract void startEndpoint(WorkerPool var1) throws AxisFault;

    public abstract void stopEndpoint();
}

