/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.util;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;

public class BufferFactory {
    private volatile ByteBuffer[] buffers;
    private volatile int marker = -1;
    private ByteBufferAllocator allocator = null;
    private Lock lock = new ReentrantLock();
    private int bufferSize = 8192;

    public BufferFactory(int bufferSize, ByteBufferAllocator allocator, int size) {
        this.bufferSize = bufferSize;
        this.allocator = allocator != null ? allocator : new HeapByteBufferAllocator();
        this.buffers = new ByteBuffer[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuffer() {
        if (this.marker == -1) {
            return this.allocator.allocate(this.bufferSize);
        }
        this.lock.lock();
        try {
            if (this.marker >= 0) {
                ByteBuffer b = this.buffers[this.marker];
                this.buffers[this.marker] = null;
                --this.marker;
                ByteBuffer byteBuffer = b;
                return byteBuffer;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.allocator.allocate(this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ByteBuffer buffer) {
        this.lock.lock();
        try {
            if (this.marker < this.buffers.length - 1) {
                this.buffers[++this.marker] = buffer;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

