/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.NHttpServerIOTarget;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.logging.LoggingIOSession;
import org.wso2.carbon.transport.passthru.logging.LoggingNHttpSourceConnection;
import org.wso2.carbon.transport.passthru.logging.LoggingNHttpTargetConnection;
import org.wso2.carbon.transport.passthru.logging.LoggingSourceHandler;
import org.wso2.carbon.transport.passthru.logging.LoggingTargetHandler;

public class LoggingUtils {
    public static final String HEADER_LOG_ID = "org.wso2.carbon.transport.passthru.headers";
    public static final String WIRE_LOG_ID = "org.wso2.carbon.transport.passthru.wire";

    public static IOSession decorate(IOSession session, String id) {
        Log log = LogFactory.getLog(session.getClass());
        Log wirelog = LogFactory.getLog((String)WIRE_LOG_ID);
        if (wirelog.isDebugEnabled() || log.isDebugEnabled()) {
            session = new LoggingIOSession(wirelog, session, id);
        }
        return session;
    }

    public static NHttpClientHandler decorate(NHttpClientHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingTargetHandler(handler);
        }
        return handler;
    }

    public static NHttpServiceHandler decorate(NHttpServiceHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingSourceHandler(handler);
        }
        return handler;
    }

    public static NHttpClientIOTarget createClientConnection(IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        Log log = LogFactory.getLog(DefaultNHttpClientConnection.class);
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (headerlog.isDebugEnabled() || log.isDebugEnabled()) {
            return new LoggingNHttpTargetConnection(log, headerlog, iosession, responseFactory, allocator, params);
        }
        return new DefaultNHttpClientConnection(iosession, responseFactory, allocator, params);
    }

    public static NHttpServerIOTarget createServerConnection(IOSession iosession, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Log log = LogFactory.getLog(DefaultNHttpClientConnection.class);
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (headerlog.isDebugEnabled() || log.isDebugEnabled()) {
            return new LoggingNHttpSourceConnection(log, headerlog, iosession, requestFactory, allocator, params);
        }
        return new DefaultNHttpServerConnection(iosession, requestFactory, allocator, params);
    }
}

