/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.logging;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class LoggingNHttpTargetConnection
extends DefaultNHttpClientConnection {
    private final Log log;
    private final Log headerLog;

    public LoggingNHttpTargetConnection(Log log, Log headerlog, IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(iosession, responseFactory, allocator, params);
        this.log = log;
        this.headerLog = headerlog;
    }

    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        super.close();
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        super.shutdown();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + (Object)((Object)this) + ": " + request.getRequestLine().toString()));
        }
        super.submitRequest(request);
    }

    public void consumeInput(NHttpClientHandler handler) {
        this.log.debug((Object)"Consume input");
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpClientHandler handler) {
        this.log.debug((Object)"Produce output");
        super.produceOutput(handler);
    }

    protected NHttpMessageWriter createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter(super.createRequestWriter(buffer, params));
    }

    protected NHttpMessageParser createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new LoggingNHttpMessageParser(super.createResponseParser(buffer, responseFactory, params));
    }

    class LoggingNHttpMessageParser
    implements NHttpMessageParser {
        private final NHttpMessageParser parser;

        public LoggingNHttpMessageParser(NHttpMessageParser parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpMessage parse() throws IOException, HttpException {
            HttpMessage message = this.parser.parse();
            if (message != null && LoggingNHttpTargetConnection.this.headerLog.isDebugEnabled()) {
                Header[] headers;
                HttpResponse response = (HttpResponse)message;
                LoggingNHttpTargetConnection.this.headerLog.debug((Object)("<< " + response.getStatusLine().toString()));
                for (Header header : headers = response.getAllHeaders()) {
                    LoggingNHttpTargetConnection.this.headerLog.debug((Object)("<< " + header.toString()));
                }
            }
            return message;
        }
    }

    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter {
        private final NHttpMessageWriter writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpMessage message) throws IOException, HttpException {
            if (message != null && LoggingNHttpTargetConnection.this.headerLog.isDebugEnabled()) {
                Header[] headers;
                HttpRequest request = (HttpRequest)message;
                LoggingNHttpTargetConnection.this.headerLog.debug((Object)(">> " + request.getRequestLine().toString()));
                for (Header header : headers = request.getAllHeaders()) {
                    LoggingNHttpTargetConnection.this.headerLog.debug((Object)(">> " + header.toString()));
                }
            }
            this.writer.write(message);
        }
    }
}

