/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.TargetContext;
import org.wso2.carbon.transport.passthru.config.TargetConfiguration;

public class TargetRequest {
    private TargetConfiguration targetConfiguration;
    private Pipe pipe = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private URL url;
    private String method;
    private HttpRequest request = null;
    private boolean chunk = true;
    private ProtocolVersion version = null;
    private boolean fullUrl = false;
    private int port = 80;
    private boolean hasEntityBody = true;
    private boolean keepAlive = true;

    public TargetRequest(TargetConfiguration targetConfiguration, URL url, String method, boolean hasEntityBody) {
        this(targetConfiguration, method, url, hasEntityBody);
    }

    public TargetRequest(TargetConfiguration targetConfiguration, String method, URL url, boolean hasEntityBody) {
        this.method = method;
        this.url = url;
        this.targetConfiguration = targetConfiguration;
        this.hasEntityBody = hasEntityBody;
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
    }

    public void start(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.pipe != null) {
            TargetContext.get((NHttpConnection)conn).setWriter(this.pipe);
        }
        String path = this.fullUrl ? this.url.toString() : this.url.getPath() + (this.url.getQuery() != null ? "?" + this.url.getQuery() : "");
        int contentLength = -1;
        String contentLengthHeader = this.headers.get("Content-Length");
        if (contentLengthHeader != null) {
            contentLength = Integer.parseInt(contentLengthHeader);
            this.headers.remove("Content-Length");
        }
        if (this.hasEntityBody) {
            this.request = new BasicHttpEntityEnclosingRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
            BasicHttpEntity entity = new BasicHttpEntity();
            if (contentLength != -1) {
                entity.setChunked(false);
                entity.setContentLength((long)contentLength);
            } else {
                entity.setChunked(this.chunk);
            }
            ((BasicHttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        } else {
            this.request = new BasicHttpRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
        }
        Set<Map.Entry<String, String>> entries = this.headers.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            this.request.setHeader(entry.getKey(), entry.getValue());
        }
        this.request.setParams((HttpParams)new DefaultedHttpParams(this.request.getParams(), this.targetConfiguration.getHttpParameters()));
        if (!this.keepAlive) {
            this.request.setHeader("Connection", "Close");
        }
        conn.getContext().setAttribute("http.connection", (Object)conn);
        conn.getContext().setAttribute("http.target_host", (Object)new HttpHost(this.url.getHost(), this.port));
        conn.getContext().setAttribute("http.request", (Object)this.request);
        this.targetConfiguration.getHttpProcessor().process(this.request, conn.getContext());
        conn.submitRequest(this.request);
        if (this.hasEntityBody) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
        } else {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
    }

    public int write(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = this.pipe.consume(encoder);
        if (encoder.isCompleted()) {
            this.targetConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
        return bytes;
    }

    public boolean hasEntityBody() {
        return this.hasEntityBody;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getMethod() {
        return this.method;
    }

    public void setChunk(boolean chunk) {
        this.chunk = chunk;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setFullUrl(boolean fullUrl) {
        this.fullUrl = fullUrl;
    }

    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

