/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.ServerWorker;
import org.wso2.carbon.transport.passthru.SourceContext;
import org.wso2.carbon.transport.passthru.SourceRequest;
import org.wso2.carbon.transport.passthru.SourceResponse;
import org.wso2.carbon.transport.passthru.config.SourceConfiguration;
import org.wso2.carbon.transport.passthru.jmx.LatencyView;
import org.wso2.carbon.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class SourceHandler
implements NHttpServiceHandler {
    private static Log log = LogFactory.getLog(SourceHandler.class);
    private final SourceConfiguration sourceConfiguration;
    private PassThroughTransportMetricsCollector metrics = null;
    private LatencyView latencyView = null;
    private LatencyView s2sLatencyView = null;

    public SourceHandler(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        this.metrics = sourceConfiguration.getMetrics();
        try {
            if (!sourceConfiguration.isSsl()) {
                this.latencyView = new LatencyView("PasstroughtHTTPLatencyView", sourceConfiguration.isSsl());
            } else {
                this.s2sLatencyView = new LatencyView("PasstroughtHTTPSLatencyView", sourceConfiguration.isSsl());
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void connected(NHttpServerConnection conn) {
        this.sourceConfiguration.getSourceConnections().addConnection(conn);
        SourceContext.create((NHttpConnection)conn, ProtocolState.REQUEST_READY, this.sourceConfiguration);
        this.metrics.connected();
    }

    public void requestReceived(NHttpServerConnection conn) {
        try {
            HttpContext context = conn.getContext();
            context.setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            if (!SourceContext.assertState((NHttpConnection)conn, ProtocolState.REQUEST_READY)) {
                this.handleInvalidState(conn, "Request received");
            }
            this.sourceConfiguration.getSourceConnections().useConnection(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
            SourceRequest request = new SourceRequest(this.sourceConfiguration, conn.getHttpRequest(), conn);
            SourceContext.setRequest((NHttpConnection)conn, request);
            request.start(conn);
            this.metrics.incrementMessagesReceived();
            this.sourceConfiguration.getWorkerPool().execute((Runnable)new ServerWorker(request, this.sourceConfiguration));
        }
        catch (HttpException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState != ProtocolState.REQUEST_HEAD && protocolState != ProtocolState.REQUEST_BODY) {
                this.handleInvalidState(conn, "Request message body data received");
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_BODY);
            SourceRequest request = SourceContext.getRequest((NHttpConnection)conn);
            int readBytes = request.read(conn, decoder);
            if (readBytes > 0) {
                this.metrics.incrementBytesReceived(readBytes);
            }
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        try {
            SourceResponse response;
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState.compareTo(ProtocolState.REQUEST_DONE) < 0) {
                return;
            }
            if (protocolState.compareTo(ProtocolState.CLOSING) >= 0) {
                return;
            }
            if (protocolState != ProtocolState.REQUEST_DONE) {
                this.handleInvalidState(conn, "Writing a response");
            }
            if ((response = SourceContext.getResponse((NHttpConnection)conn)) != null) {
                response.start(conn);
                this.metrics.incrementMessagesSent();
            }
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
        catch (HttpException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState != ProtocolState.RESPONSE_HEAD && protocolState != ProtocolState.RESPONSE_BODY) {
                log.warn((Object)("Illegal incoming connection state: " + (Object)((Object)protocolState) + " . Possibly two send backs " + "are happening for the same request"));
                this.handleInvalidState(conn, "Trying to write response body");
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_BODY);
            SourceResponse response = SourceContext.getResponse((NHttpConnection)conn);
            int bytesSent = response.write(conn, encoder);
            this.metrics.incrementBytesSent(bytesSent);
            if (encoder.isCompleted()) {
                if (context.getAttribute("REQ_ARRIVAL_TIME") != null && context.getAttribute("REQ_DEPARTURE_TIME") != null && context.getAttribute("RES_HEADER_ARRIVAL_TIME") != null) {
                    if (this.latencyView != null) {
                        this.latencyView.notifyTimes((Long)context.getAttribute("REQ_ARRIVAL_TIME"), (Long)context.getAttribute("REQ_DEPARTURE_TIME"), (Long)context.getAttribute("RES_HEADER_ARRIVAL_TIME"), System.currentTimeMillis());
                    } else if (this.s2sLatencyView != null) {
                        this.s2sLatencyView.notifyTimes((Long)context.getAttribute("REQ_ARRIVAL_TIME"), (Long)context.getAttribute("REQ_DEPARTURE_TIME"), (Long)context.getAttribute("RES_HEADER_ARRIVAL_TIME"), System.currentTimeMillis());
                    }
                }
                context.removeAttribute("REQ_ARRIVAL_TIME");
                context.removeAttribute("REQ_DEPARTURE_TIME");
                context.removeAttribute("RES_HEADER_ARRIVAL_TIME");
            }
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        this.logIOException(e);
        this.metrics.incrementFaultsReceiving();
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.informReaderError(conn);
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
        } else if (state == ProtocolState.REQUEST_DONE) {
            this.informWriterError(conn);
        } else if (state == ProtocolState.RESPONSE_DONE) {
            this.informWriterError(conn);
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
    }

    private void logIOException(IOException e) {
        if (e instanceof ConnectionClosedException || e.getMessage() != null && e.getMessage().toLowerCase().contains("connection reset by peer") || e.getMessage().toLowerCase().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably the keepalive connection was closed):" + e.getMessage()));
            }
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("broken") != -1) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
            this.metrics.incrementFaultsReceiving();
        } else {
            log.error((Object)("Unexpected I/O error: " + e.getClass().getName()), (Throwable)e);
            this.metrics.incrementFaultsReceiving();
        }
    }

    public void exception(NHttpServerConnection conn, HttpException e) {
        try {
            if (conn.isResponseSubmitted()) {
                this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
                return;
            }
            HttpContext httpContext = conn.getContext();
            BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 400, "Bad request");
            response.setParams((HttpParams)new DefaultedHttpParams(this.sourceConfiguration.getHttpParameters(), response.getParams()));
            response.addHeader("Connection", "Close");
            httpContext.setAttribute("http.connection", (Object)conn);
            httpContext.setAttribute("http.request", null);
            httpContext.setAttribute("http.response", (Object)response);
            this.sourceConfiguration.getHttpProcessor().process((HttpResponse)response, httpContext);
            conn.submitResponse((HttpResponse)response);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            conn.close();
        }
        catch (Exception e1) {
            log.error((Object)e.getMessage(), (Throwable)e);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void timeout(NHttpServerConnection conn) {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive connection was time out: " + conn));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.metrics.incrementTimeoutsReceiving();
            this.informReaderError(conn);
            log.warn((Object)("Connection time out while reading the request: " + conn));
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
            log.warn((Object)("Connection time out while writing the response: " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            log.warn((Object)("Connection time out after request is read: " + conn));
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
    }

    public void closed(NHttpServerConnection conn) {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive connection was closed: " + conn));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.informReaderError(conn);
            log.warn((Object)("Connection closed while reading the request: " + conn));
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
            log.warn((Object)("Connection closed while writing the response: " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            log.warn((Object)("Connection closed by the client after request is read: " + conn));
        }
        this.metrics.disconnected();
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
    }

    private void handleInvalidState(NHttpServerConnection conn, String action) {
        log.warn((Object)(action + " while the handler is in an inconsistent state " + (Object)((Object)SourceContext.getState((NHttpConnection)conn))));
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn);
    }

    private void informReaderError(NHttpServerConnection conn) {
        Pipe reader = SourceContext.get((NHttpConnection)conn).getReader();
        this.metrics.incrementFaultsReceiving();
        if (reader != null) {
            reader.producerError();
        }
    }

    private void informWriterError(NHttpServerConnection conn) {
        Pipe writer = SourceContext.get((NHttpConnection)conn).getWriter();
        this.metrics.incrementFaultsSending();
        if (writer != null) {
            writer.consumerError();
        }
    }
}

