/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.net.InetAddress;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpInetConnection;
import org.wso2.carbon.transport.passthru.PassThroughHttpListener;
import org.wso2.carbon.transport.passthru.SourceRequest;
import org.wso2.carbon.transport.passthru.config.SourceConfiguration;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private MessageContext msgContext = null;
    private SourceRequest request = null;
    private SourceConfiguration sourceConfiguration = null;
    private static final String SOAP_ACTION_HEADER = "SOAPAction";

    public ServerWorker(SourceRequest request, SourceConfiguration sourceConfiguration) {
        this.request = request;
        this.sourceConfiguration = sourceConfiguration;
        this.msgContext = this.createMessageContext(request);
        this.msgContext.setProperty("pass-through.Source-Request", (Object)request);
        this.msgContext.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", (Object)sourceConfiguration);
        this.msgContext.setProperty("pass-through.Source-Connection", (Object)request.getConnection());
    }

    @Override
    public void run() {
        HttpInetConnection inetConn;
        InetAddress localAddr;
        int pos;
        String uri;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting a new Server Worker instance");
        }
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        this.msgContext.setProperty("HTTP_METHOD", (Object)this.request.getMethod());
        String oriUri = uri = this.request.getUri();
        if (uri.indexOf(cfgCtx.getServicePath()) != -1) {
            pos = (uri = uri.substring(uri.indexOf(cfgCtx.getServicePath()) + cfgCtx.getServicePath().length())).indexOf("/", 1);
            uri = pos > 0 ? uri.substring(pos) : ((pos = uri.indexOf("?")) != -1 ? uri.substring(pos) : "");
        } else {
            pos = uri.indexOf("://");
            if (pos != -1 && (pos = (uri = uri.substring(pos + 3)).indexOf("/")) != -1) {
                uri = uri.substring(pos + 1);
            }
        }
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(uri));
        if (servicePrefix.indexOf("://") == -1 && (localAddr = (inetConn = (HttpInetConnection)this.request.getConnection()).getLocalAddress()) != null) {
            servicePrefix = (this.sourceConfiguration.isSsl() ? "https://" : "http://") + localAddr.getHostAddress() + ":" + inetConn.getLocalPort() + servicePrefix;
        }
        this.msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        this.msgContext.setTo(new EndpointReference(uri));
        this.msgContext.setProperty("REST_URL_POSTFIX", (Object)uri);
        if (this.request.isEntityEnclosing()) {
            this.processEntityEnclosingRequest();
        } else {
            this.processNonEntityEnclosingMethod();
        }
    }

    private void processNonEntityEnclosingMethod() {
        String soapAction = this.request.getHeader(SOAP_ACTION_HEADER);
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        this.msgContext.setSoapAction(soapAction);
        this.msgContext.setTo(new EndpointReference(this.request.getUri()));
        this.msgContext.setServerSide(true);
        this.msgContext.setDoingREST(true);
        this.msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        try {
            this.msgContext.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
            AxisEngine.receive((MessageContext)this.msgContext);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
    }

    private void processEntityEnclosingRequest() {
        try {
            String contentTypeHeader = this.request.getHeader("Content-Type");
            contentTypeHeader = contentTypeHeader != null ? contentTypeHeader : this.inferContentType();
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeHeader);
            String contentType = TransportUtils.getContentType((String)contentTypeHeader, (MessageContext)this.msgContext);
            if (charSetEncoding == null) {
                charSetEncoding = "UTF-8";
            }
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            this.msgContext.setProperty("ContentType", (Object)contentType);
            this.msgContext.setProperty("messageType", (Object)contentType);
            this.msgContext.setTo(new EndpointReference(this.request.getUri()));
            this.msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)this.request.getMethod());
            this.msgContext.setServerSide(true);
            if (HTTPTransportUtils.isRESTRequest((String)contentTypeHeader) || this.isRest(contentType)) {
                this.msgContext.setProperty("synapse.internal.rest.contentType", (Object)contentType);
                this.msgContext.setDoingREST(true);
                String messageType = (String)this.msgContext.getProperty("messageType");
                if ("application/x-www-form-urlencoded".equals(messageType) || "multipart/form-data".equals(messageType)) {
                    this.msgContext.setProperty("messageType", (Object)"application/xml");
                }
                SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                SOAPEnvelope envelope = fac.getDefaultEnvelope();
                this.msgContext.setEnvelope(envelope);
            } else {
                SOAPEnvelope envelope;
                String soapAction = this.request.getHeader(SOAP_ACTION_HEADER);
                int soapVersion = HTTPTransportUtils.initializeMessageContext((MessageContext)this.msgContext, (String)soapAction, (String)this.request.getUri(), (String)contentTypeHeader);
                if (soapVersion == 1) {
                    SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                    envelope = fac.getDefaultEnvelope();
                } else if (soapVersion == 2) {
                    SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                    envelope = fac.getDefaultEnvelope();
                } else {
                    SOAPFactory fac = OMAbstractFactory.getSOAP12Factory();
                    envelope = fac.getDefaultEnvelope();
                }
                this.msgContext.setEnvelope(envelope);
            }
            this.msgContext.setProperty("pass-through.pipe", (Object)this.request.getPipe());
            AxisEngine.receive((MessageContext)this.msgContext);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + this.request.getMethod() + " request for : " + this.request.getUri(), (Exception)((Object)axisFault));
        }
    }

    private boolean isRest(String contentType) {
        return contentType != null && contentType.indexOf("text/xml") == -1 && contentType.indexOf("application/soap+xml") == -1;
    }

    private MessageContext createMessageContext(SourceRequest request) {
        ConfigurationContext cfgCtx = this.sourceConfiguration.getConfigurationContext();
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UUIDGenerator.getUUID());
        msgContext.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(cfgCtx);
        TransportInDescription trpInDesc = this.sourceConfiguration.getInDescription();
        TransportOutDescription trpOutDesc = cfgCtx.getAxisConfiguration().getTransportOut(trpInDesc.getName());
        msgContext.setTransportIn(trpInDesc);
        String protocol = trpInDesc.getReceiver() instanceof PassThroughHttpListener ? "http" : "https";
        msgContext.setIncomingTransportName(protocol);
        msgContext.setTransportOut(trpOutDesc);
        msgContext.setProperty("TRANSPORT_OUT_DESCRIPTION", (Object)trpOutDesc);
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        Set<Map.Entry<String, String>> entries = request.getAllHeaders().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            headers.put(entry.getKey(), entry.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        return msgContext;
    }

    private void handleException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (e == null) {
            e = new Exception(msg);
        }
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)e);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String inferContentType() {
        Parameter param = this.sourceConfiguration.getConfigurationContext().getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }
}

