/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.TargetContext;
import org.wso2.carbon.transport.passthru.TargetErrorHandler;
import org.wso2.carbon.transport.passthru.TargetRequest;
import org.wso2.carbon.transport.passthru.config.TargetConfiguration;
import org.wso2.carbon.transport.passthru.connections.TargetConnections;
import org.wso2.carbon.transport.passthru.util.TargetRequestFactory;

public class DeliveryAgent {
    private static final Log log = LogFactory.getLog(DeliveryAgent.class);
    private Map<String, Queue<MessageContext>> waitingMessages = new ConcurrentHashMap<String, Queue<MessageContext>>();
    private TargetConnections targetConnections;
    private TargetConfiguration targetConfiguration;
    private int maxWaitingMessages = Integer.MAX_VALUE;
    private TargetErrorHandler targetErrorHandler;
    private Lock lock = new ReentrantLock();

    public DeliveryAgent(TargetConfiguration targetConfiguration, TargetConnections targetConnections) {
        this.targetConfiguration = targetConfiguration;
        this.targetConnections = targetConnections;
        this.targetErrorHandler = new TargetErrorHandler(targetConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(MessageContext msgContext, EndpointReference epr) throws AxisFault {
        try {
            MessageContext messageContext;
            URL url = new URL(epr.getAddress());
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                if ("http".equals(url.getProtocol())) {
                    port = 80;
                } else if ("https".equals(url.getProtocol())) {
                    port = 443;
                }
            }
            String key = host + ":" + port;
            Queue<MessageContext> queue = null;
            this.lock.lock();
            try {
                queue = this.waitingMessages.get(key);
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<MessageContext>();
                    this.waitingMessages.put(key, queue);
                }
                if (queue.size() == this.maxWaitingMessages) {
                    MessageContext msgCtx = queue.poll();
                    this.targetErrorHandler.handleError(msgCtx, 102540, "Error connecting to the back end", null, ProtocolState.REQUEST_READY);
                }
                queue.add(msgContext);
            }
            finally {
                this.lock.unlock();
            }
            NHttpClientConnection conn = this.targetConnections.getConnection(host, port);
            if (conn != null && (messageContext = queue.poll()) != null) {
                this.tryNextMessage(messageContext, conn);
            }
        }
        catch (MalformedURLException e) {
            this.handleException("Malformed URL in the target EPR", e);
        }
    }

    public void errorConnecting(String host, int port, int errorCode, String message) {
        String key = host + ":" + port;
        Queue<MessageContext> queue = this.waitingMessages.get(key);
        if (queue != null) {
            MessageContext msgCtx = queue.poll();
            if (msgCtx != null) {
                this.targetErrorHandler.handleError(msgCtx, errorCode, "Error connecting to the back end", null, ProtocolState.REQUEST_READY);
            }
        } else {
            throw new IllegalStateException("Queue cannot be null for: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(String host, int port) {
        NHttpClientConnection conn;
        Queue<MessageContext> queue = null;
        this.lock.lock();
        try {
            queue = this.waitingMessages.get(host + ":" + port);
        }
        finally {
            this.lock.unlock();
        }
        while (queue.size() > 0 && (conn = this.targetConnections.getConnection(host, port)) != null) {
            MessageContext messageContext = queue.poll();
            if (messageContext == null) continue;
            this.tryNextMessage(messageContext, conn);
        }
    }

    private void tryNextMessage(MessageContext messageContext, NHttpClientConnection conn) {
        if (conn != null) {
            try {
                TargetContext.get((NHttpConnection)conn).setRequestMsgCtx(messageContext);
                this.submitRequest(conn, messageContext);
            }
            catch (AxisFault e) {
                log.error((Object)"IO error while sending the request out", (Throwable)e);
            }
        }
    }

    private void submitRequest(NHttpClientConnection conn, MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting new request to the connection: " + conn));
        }
        TargetRequest request = TargetRequestFactory.create(msgContext, this.targetConfiguration);
        TargetContext.setRequest((NHttpConnection)conn, request);
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (pipe != null) {
            pipe.attachConsumer((IOControl)conn);
            request.connect(pipe);
        }
        conn.requestOutput();
    }

    private void handleException(String s, Exception e) throws AxisFault {
        log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }
}

