/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.logging;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class LoggingNHttpSourceConnection
extends DefaultNHttpServerConnection {
    private final Log log;
    private final Log headerLog;

    public LoggingNHttpSourceConnection(Log log, Log headerlog, IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, requestFactory, allocator, params);
        this.log = log;
        this.headerLog = headerlog;
    }

    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        super.close();
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        super.shutdown();
    }

    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + (Object)((Object)this) + ": " + response.getStatusLine().toString()));
        }
        super.submitResponse(response);
    }

    public void consumeInput(NHttpServiceHandler handler) {
        this.log.debug((Object)"Consume input");
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpServiceHandler handler) {
        this.log.debug((Object)"Produce output");
        super.produceOutput(handler);
    }

    protected NHttpMessageWriter createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter(super.createResponseWriter(buffer, params));
    }

    protected NHttpMessageParser createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new LoggingNHttpMessageParser(super.createRequestParser(buffer, requestFactory, params));
    }

    class LoggingNHttpMessageParser
    implements NHttpMessageParser {
        private final NHttpMessageParser parser;

        public LoggingNHttpMessageParser(NHttpMessageParser parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpMessage parse() throws IOException, HttpException {
            HttpMessage message = this.parser.parse();
            if (message != null && LoggingNHttpSourceConnection.this.headerLog.isDebugEnabled()) {
                Header[] headers;
                HttpRequest request = (HttpRequest)message;
                LoggingNHttpSourceConnection.this.headerLog.debug((Object)(">> " + request.getRequestLine().toString()));
                for (Header header : headers = request.getAllHeaders()) {
                    LoggingNHttpSourceConnection.this.headerLog.debug((Object)(">> " + header.toString()));
                }
            }
            return message;
        }
    }

    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter {
        private final NHttpMessageWriter writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpMessage message) throws IOException, HttpException {
            if (message != null && LoggingNHttpSourceConnection.this.headerLog.isDebugEnabled()) {
                Header[] headers;
                HttpResponse response = (HttpResponse)message;
                LoggingNHttpSourceConnection.this.headerLog.debug((Object)("<< " + response.getStatusLine().toString()));
                for (Header header : headers = response.getAllHeaders()) {
                    LoggingNHttpSourceConnection.this.headerLog.debug((Object)("<< " + header.toString()));
                }
            }
            this.writer.write(message);
        }
    }
}

