/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.connections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.wso2.carbon.transport.passthru.SourceContext;

public class SourceConnections {
    private static Log log = LogFactory.getLog(SourceConnections.class);
    private volatile List<NHttpServerConnection> busyConnections = new ArrayList<NHttpServerConnection>();
    private volatile List<NHttpServerConnection> freeConnections = new ArrayList<NHttpServerConnection>();
    private final Lock lock = new ReentrantLock();
    private int maxFreeConnections;
    private int maxBusyConnections;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(NHttpServerConnection conn) {
        this.lock.lock();
        try {
            this.freeConnections.add(conn);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useConnection(NHttpServerConnection conn) {
        block5: {
            this.lock.lock();
            try {
                boolean freeConnection = this.freeConnections.remove(conn);
                if (freeConnection) {
                    this.busyConnections.add(conn);
                    break block5;
                }
                if (this.busyConnections.contains(conn)) {
                    throw new IllegalStateException("The connection is busy. Cannot use it for new request");
                }
                throw new IllegalStateException("Trying to use a connection which is not in free connections " + conn);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(NHttpServerConnection conn) {
        block4: {
            this.lock.lock();
            try {
                SourceContext.get((NHttpConnection)conn).reset();
                if (this.busyConnections.remove(conn)) {
                    this.freeConnections.add(conn);
                    break block4;
                }
                throw new IllegalStateException("Trying to finish using a connection which is not in busy connections " + conn);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownConnection(NHttpServerConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Shutting down connection forcefully " + conn));
        }
        this.lock.lock();
        try {
            SourceContext.get((NHttpConnection)conn).reset();
            this.freeConnections.remove(conn);
            this.busyConnections.remove(conn);
            try {
                conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        for (NHttpServerConnection conn : this.freeConnections) {
            this.shutDownConnection(conn);
        }
        for (NHttpServerConnection conn : this.busyConnections) {
            SourceContext.get((NHttpConnection)conn).setShutDown(true);
        }
    }
}

