/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.TargetContext;
import org.wso2.carbon.transport.passthru.config.TargetConfiguration;

public class TargetResponse {
    private Pipe pipe = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = 200;
    private String statusLine = "OK";
    private HttpResponse response = null;
    private TargetConfiguration targetConfiguration;
    private ProtocolVersion version = HttpVersion.HTTP_1_1;
    private ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
    private NHttpClientConnection connection;
    private boolean expectResponseBody = true;

    public TargetResponse(TargetConfiguration targetConfiguration, HttpResponse response, NHttpClientConnection conn, boolean expectResponseBody) {
        this.targetConfiguration = targetConfiguration;
        this.response = response;
        this.connection = conn;
        this.version = response.getProtocolVersion();
        this.status = response.getStatusLine().getStatusCode();
        this.statusLine = response.getStatusLine().getReasonPhrase();
        Header[] headers = response.getAllHeaders();
        if (headers != null) {
            for (Header header : headers) {
                this.headers.put(header.getName(), header.getValue());
            }
        }
        this.expectResponseBody = expectResponseBody;
    }

    public void start(NHttpClientConnection conn) {
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_HEAD);
        if (this.expectResponseBody) {
            this.pipe = new Pipe((IOControl)conn, this.targetConfiguration.getBufferFactory().getBuffer(), "target");
            TargetContext.get((NHttpConnection)conn).setReader(this.pipe);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (this.response.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            this.response.setEntity((HttpEntity)entity);
        } else if (!this.connStrategy.keepAlive(this.response, conn.getContext())) {
            try {
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.targetConfiguration.getConnections().releaseConnection(conn);
                conn.close();
            }
            catch (Exception exception) {}
        } else {
            this.targetConfiguration.getConnections().releaseConnection(conn);
        }
    }

    public int read(NHttpClientConnection conn, ContentDecoder decoder) throws IOException {
        int bytes = this.pipe.produce(decoder);
        if (decoder.isCompleted()) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.targetConfiguration.getMetrics().notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
            if (!this.connStrategy.keepAlive(this.response, conn.getContext())) {
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
            } else {
                this.targetConfiguration.getConnections().releaseConnection(conn);
            }
        }
        return bytes;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public boolean isExpectResponseBody() {
        return this.expectResponseBody;
    }

    public NHttpClientConnection getConnection() {
        return this.connection;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }
}

