/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.SourceContext;
import org.wso2.carbon.transport.passthru.SourceRequest;
import org.wso2.carbon.transport.passthru.config.SourceConfiguration;

public class SourceResponse {
    private Pipe pipe = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = 200;
    private String statusLine = null;
    private HttpResponse response = null;
    private SourceConfiguration sourceConfiguration;
    private ProtocolVersion version = HttpVersion.HTTP_1_1;
    private ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
    private SourceRequest request = null;

    public SourceResponse(SourceConfiguration config, int status, SourceRequest request) {
        this(config, status, null, request);
    }

    public SourceResponse(SourceConfiguration config, int status, String statusLine, SourceRequest request) {
        this.status = status;
        this.statusLine = statusLine;
        this.sourceConfiguration = config;
        this.request = request;
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
        SourceContext.get((NHttpConnection)this.request.getConnection()).setWriter(pipe);
    }

    public void start(NHttpServerConnection conn) throws IOException, HttpException {
        this.response = this.sourceConfiguration.getResponseFactory().newHttpResponse(this.request.getVersion(), 200, this.request.getConnection().getContext());
        if (this.statusLine != null) {
            this.response.setStatusLine(this.version, this.status, this.statusLine);
        } else {
            this.response.setStatusCode(this.status);
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        int contentLength = -1;
        String contentLengthHeader = this.headers.get("Content-Length");
        if (contentLengthHeader != null) {
            contentLength = Integer.parseInt(contentLengthHeader);
            this.headers.remove("Content-Length");
        }
        if (contentLength != -1) {
            entity.setChunked(false);
            entity.setContentLength((long)contentLength);
        } else {
            entity.setChunked(true);
        }
        this.response.setEntity((HttpEntity)entity);
        Set<Map.Entry<String, String>> entries = this.headers.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (entry.getKey() == null) continue;
            this.response.addHeader(entry.getKey(), entry.getValue());
        }
        this.response.setParams((HttpParams)new DefaultedHttpParams(this.response.getParams(), this.sourceConfiguration.getHttpParameters()));
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_HEAD);
        conn.getContext().setAttribute("http.connection", (Object)conn);
        conn.getContext().setAttribute("http.response", (Object)this.response);
        conn.getContext().setAttribute("http.request", (Object)SourceContext.getRequest((NHttpConnection)conn).getRequest());
        this.sourceConfiguration.getHttpProcessor().process(this.response, conn.getContext());
        conn.submitResponse(this.response);
    }

    public int write(NHttpServerConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.consume(encoder);
        } else {
            encoder.complete();
        }
        if (encoder.isCompleted()) {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.sourceConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            if (!this.connStrategy.keepAlive(this.response, conn.getContext())) {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
                conn.close();
            } else if (SourceContext.get((NHttpConnection)conn).isShutDown()) {
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
                conn.close();
            } else {
                this.sourceConfiguration.getSourceConnections().releaseConnection(conn);
                conn.requestInput();
            }
        }
        return bytes;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

