/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;

public class Pipe {
    private IOControl producerIoControl;
    private IOControl consumerIoControl;
    private ByteBuffer buffer;
    private boolean producerCompleted = false;
    private Lock lock = new ReentrantLock();
    private String name = "Buffer";
    private boolean consumerError = false;
    private boolean producerError = false;

    public Pipe(IOControl producerIoControl, ByteBuffer buffer, String name) {
        this.producerIoControl = producerIoControl;
        this.buffer = buffer;
        this.name = this.name + "_" + name;
    }

    public void attachConsumer(IOControl consumerIoControl) {
        this.consumerIoControl = consumerIoControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consume(ContentEncoder encoder) throws IOException {
        if (this.consumerIoControl == null) {
            throw new IllegalStateException("Consumer cannot be null when calling consume");
        }
        if (this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling consume");
        }
        this.lock.lock();
        try {
            if (this.producerError) {
                encoder.complete();
                int n = -1;
                return n;
            }
            this.buffer.flip();
            int bytesWritten = encoder.write(this.buffer);
            this.buffer.compact();
            if (this.buffer.position() == 0) {
                if (this.producerCompleted) {
                    encoder.complete();
                } else {
                    this.consumerIoControl.suspendOutput();
                }
            }
            if (bytesWritten > 0 && !encoder.isCompleted()) {
                this.producerIoControl.requestInput();
            }
            int n = bytesWritten;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produce(ContentDecoder decoder) throws IOException {
        if (this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling produce");
        }
        this.lock.lock();
        try {
            int bytesRead = decoder.read(this.buffer);
            if (this.consumerError) {
                this.buffer.clear();
            }
            if (!this.buffer.hasRemaining()) {
                this.producerIoControl.suspendInput();
            }
            if ((this.buffer.position() > 0 || decoder.isCompleted()) && this.consumerIoControl != null) {
                this.consumerIoControl.requestOutput();
            }
            if (decoder.isCompleted()) {
                this.producerCompleted = true;
            }
            int n = bytesRead;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumerError() {
        this.lock.lock();
        try {
            this.consumerError = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void producerError() {
        this.lock.lock();
        try {
            this.producerError = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

