/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.ConnectCallback;
import org.wso2.carbon.transport.passthru.DeliveryAgent;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.ServerWorker;
import org.wso2.carbon.transport.passthru.SourceContext;
import org.wso2.carbon.transport.passthru.SourceRequest;
import org.wso2.carbon.transport.passthru.SourceResponse;
import org.wso2.carbon.transport.passthru.TargetHandler;
import org.wso2.carbon.transport.passthru.TargetIOEventDispatch;
import org.wso2.carbon.transport.passthru.config.SourceConfiguration;
import org.wso2.carbon.transport.passthru.config.TargetConfiguration;
import org.wso2.carbon.transport.passthru.connections.TargetConnections;
import org.wso2.carbon.transport.passthru.jmx.MBeanRegistrar;
import org.wso2.carbon.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.wso2.carbon.transport.passthru.jmx.TransportView;
import org.wso2.carbon.transport.passthru.util.PassThroughTransportUtils;
import org.wso2.carbon.transport.passthru.util.SourceResponseFactory;

public class PassThroughHttpSender
extends AbstractHandler
implements TransportSender {
    protected Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private DefaultConnectingIOReactor ioReactor;
    private DeliveryAgent deliveryAgent;
    private TargetConfiguration targetConfiguration;
    private volatile int state = 0;
    private SSLContext sslContext = null;
    private String namePrefix;

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOutDescription) throws AxisFault {
        this.log.info((Object)"Initializing Pass-through HTTP/S Sender...");
        this.sslContext = this.getSSLContext(transportOutDescription);
        SSLIOSessionHandler sslSetupHandler = this.getSSLSetupHandler(transportOutDescription);
        this.namePrefix = this.sslContext == null ? "HTTP" : "HTTPS";
        WorkerPool workerPool = null;
        Object obj = configurationContext.getProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL");
        if (obj != null) {
            workerPool = (WorkerPool)obj;
        }
        this.targetConfiguration = new TargetConfiguration(configurationContext, (ParameterInclude)transportOutDescription, workerPool);
        this.targetConfiguration.build();
        configurationContext.setProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL", (Object)this.targetConfiguration.getWorkerPool());
        PassThroughTransportMetricsCollector metrics = new PassThroughTransportMetricsCollector(false, this.sslContext != null);
        TransportView view = new TransportView(null, this, metrics, null);
        MBeanRegistrar.getInstance().registerMBean(view, "Transport", "passthru-" + this.namePrefix.toLowerCase() + "-sender");
        this.targetConfiguration.setMetrics(metrics);
        try {
            String prefix = this.namePrefix + "-Sender I/O dispatcher";
            this.ioReactor = new DefaultConnectingIOReactor(this.targetConfiguration.getIOThreadsPerReactor(), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " Thread Group"), prefix), this.targetConfiguration.getHttpParameters());
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOReactorException e) {
            this.handleException("Error starting " + this.namePrefix + " ConnectingIOReactor", (Exception)((Object)e));
        }
        ConnectCallback connectCallback = new ConnectCallback();
        TargetConnections targetConnections = new TargetConnections((ConnectingIOReactor)this.ioReactor, this.targetConfiguration, connectCallback);
        this.targetConfiguration.setConnections(targetConnections);
        this.deliveryAgent = new DeliveryAgent(this.targetConfiguration, targetConnections);
        connectCallback.setDeliveryAgent(this.deliveryAgent);
        TargetHandler handler = new TargetHandler(this.deliveryAgent, this.targetConfiguration);
        final IOEventDispatch ioEventDispatch = this.getEventDispatch(handler, this.sslContext, sslSetupHandler, this.targetConfiguration.getHttpParameters(), transportOutDescription);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PassThroughHttpSender.this.ioReactor.execute(ioEventDispatch);
                }
                catch (Exception ex) {
                    PassThroughHttpSender.this.log.fatal((Object)("Exception encountered in the " + PassThroughHttpSender.this.namePrefix + " Sender. " + "No more connections will be initiated by this transport"), (Throwable)ex);
                }
                PassThroughHttpSender.this.log.info((Object)(PassThroughHttpSender.this.namePrefix + " Sender shutdown"));
            }
        }, "PassThrough" + this.namePrefix + "Sender");
        t.start();
        this.state = 1;
        this.log.info((Object)("Pass-through " + this.namePrefix + " Sender started..."));
    }

    public void cleanup(MessageContext messageContext) throws AxisFault {
    }

    public void stop() {
        try {
            this.ioReactor.shutdown();
        }
        catch (IOException e) {
            this.log.error((Object)"Error shutting down the PassThroughHttpSender", (Throwable)e);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        PassThroughTransportUtils.removeUnwantedHeaders(msgContext, this.targetConfiguration.isPreserveServerHeader(), this.targetConfiguration.isPreserveUserAgentHeader());
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress()) {
            msgContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
        }
        if ((epr = PassThroughTransportUtils.getDestinationEPR(msgContext)) != null) {
            if (!epr.hasNoneAddress()) {
                this.deliveryAgent.submit(msgContext, epr);
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else if (msgContext.getProperty("OutTransportInfo") != null) {
            if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                try {
                    this.submitResponse(msgContext);
                }
                catch (Exception e) {
                    this.handleException("Failed to submit the response", e);
                }
            }
        } else {
            this.handleException("No valid destination EPR to send message");
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected IOEventDispatch getEventDispatch(NHttpClientHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params, TransportOutDescription trpOut) throws AxisFault {
        return new TargetIOEventDispatch(handler, params);
    }

    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    protected SSLIOSessionHandler getSSLSetupHandler(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    public void submitResponse(MessageContext msgContext) throws IOException, HttpException {
        ProtocolState state;
        Integer errorCode;
        SourceConfiguration sourceConfiguration = (SourceConfiguration)msgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
        NHttpServerConnection conn = (NHttpServerConnection)msgContext.getProperty("pass-through.Source-Connection");
        SourceRequest sourceRequest = SourceContext.getRequest((NHttpConnection)conn);
        SourceResponse sourceResponse = SourceResponseFactory.create(msgContext, sourceRequest, sourceConfiguration);
        SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
        Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (!(noEntityBody != null && noEntityBody.booleanValue() && pipe == null || pipe == null)) {
            pipe.attachConsumer((IOControl)conn);
            sourceResponse.connect(pipe);
        }
        if ((errorCode = (Integer)msgContext.getProperty("ERROR_CODE")) != null) {
            sourceResponse.setStatus(502);
            SourceContext.get((NHttpConnection)conn).setShutDown(true);
        }
        if ((state = SourceContext.getState((NHttpConnection)conn)) != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
            conn.requestOutput();
        } else {
            if (errorCode != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)("A Source connection is closed because of an error in target: " + conn));
                }
            } else {
                this.log.debug((Object)("A Source Connection is closed, because source handler is already in the process of writing a response while another response is submitted: " + conn));
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            sourceConfiguration.getSourceConnections().shutDownConnection(conn);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info((Object)(this.namePrefix + " Sender Paused"));
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info((Object)(this.namePrefix + " Sender Resumed"));
    }

    public void maintenanceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            this.log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    private void handleException(String s, Exception e) throws AxisFault {
        this.log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

