/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.SSLServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.PassThroughHttpListener;

public class PassThroughHttpSSLListener
extends PassThroughHttpListener {
    private Log log = LogFactory.getLog(PassThroughHttpSSLListener.class);

    @Override
    protected IOEventDispatch getEventDispatch(NHttpServiceHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params) {
        return new SSLServerIOEventDispatch(handler, sslContext, sslIOSessionHandler, params);
    }

    @Override
    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        String storePassword;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        Parameter keyParam = transportIn.getParameter("keystore");
        Parameter trustParam = transportIn.getParameter("truststore");
        if (keyParam != null) {
            OMElement ksEle = keyParam.getParameterElement().getFirstElement();
            location = ksEle.getFirstChildWithName(new QName("Location")).getText();
            type = ksEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = ksEle.getFirstChildWithName(new QName("Password")).getText();
            String keyPassword = ksEle.getFirstChildWithName(new QName("KeyPassword")).getText();
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                this.log.info((Object)("Loading Identity Keystore from : " + location));
                keyStore.load(fis, storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                this.log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                this.log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (trustParam != null) {
            OMElement tsEle = trustParam.getParameterElement().getFirstElement();
            location = tsEle.getFirstChildWithName(new QName("Location")).getText();
            type = tsEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = tsEle.getFirstChildWithName(new QName("Password")).getText();
            FileInputStream fis = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                this.log.info((Object)("Loading Trust Keystore from : " + location));
                trustStore.load(fis, storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                this.log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                this.log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            this.log.error((Object)"Unable to create SSL context with the given configuration", (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    @Override
    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportInDescription transportIn) throws AxisFault {
        final Parameter clientAuth = transportIn.getParameter("SSLVerifyClient");
        return new SSLIOSessionHandler(){

            public void initalize(SSLEngine sslengine, HttpParams params) {
                if (clientAuth != null) {
                    if ("optional".equals(clientAuth.getValue())) {
                        sslengine.setWantClientAuth(true);
                    } else if ("require".equals(clientAuth.getValue())) {
                        sslengine.setNeedClientAuth(true);
                    }
                }
            }

            public void verify(SocketAddress removeAddress, SSLSession session) throws SSLException {
            }
        };
    }
}

