/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transport.passthru.TargetResponse;

public class ClientWorker
implements Runnable {
    private Log log = LogFactory.getLog(ClientWorker.class);
    private ConfigurationContext cfgCtx = null;
    private MessageContext responseMsgCtx = null;
    private TargetResponse response = null;
    private boolean expectEntityBody = true;

    public ClientWorker(ConfigurationContext cfgCtx, MessageContext outMsgCtx, TargetResponse response) {
        this.cfgCtx = cfgCtx;
        this.response = response;
        this.expectEntityBody = response.isExpectResponseBody();
        try {
            this.responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
            if (this.responseMsgCtx != null) {
                this.responseMsgCtx.setSoapAction("");
            }
        }
        catch (AxisFault af) {
            this.log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
            return;
        }
        if (this.responseMsgCtx == null) {
            this.responseMsgCtx = new MessageContext();
            this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        this.responseMsgCtx.setProperty("pass-through.Source-Connection", outMsgCtx.getProperty("pass-through.Source-Connection"));
        this.responseMsgCtx.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", outMsgCtx.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
        this.responseMsgCtx.setServerSide(true);
        this.responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        this.responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        this.responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
        this.responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
        Set<Map.Entry<String, String>> headerEntries = response.getHeaders().entrySet();
        TreeMap<String, String> headerMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            headerMap.put(headerEntry.getKey(), headerEntry.getValue());
        }
        this.responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
        this.responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        this.responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
        this.responseMsgCtx.setTo(null);
        this.responseMsgCtx.setProperty("pass-through.pipe", (Object)response.getPipe());
        this.responseMsgCtx.setProperty("pass-through.Target-Response", (Object)response);
        this.responseMsgCtx.setProperty("pass-through.Target-Connection", (Object)response.getConnection());
    }

    @Override
    public void run() {
        if (this.responseMsgCtx == null) {
            return;
        }
        try {
            if (this.expectEntityBody) {
                String cType = this.response.getHeader("Content-Type");
                String contentType = cType != null ? cType : this.inferContentType();
                String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
                if (charSetEnc == null) {
                    charSetEnc = "UTF-8";
                }
                this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)(contentType.indexOf("; charset=") > 0 ? charSetEnc : "UTF-8"));
                this.responseMsgCtx.setServerSide(false);
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                SOAPEnvelope envelope = fac.getDefaultEnvelope();
                try {
                    this.responseMsgCtx.setEnvelope(envelope);
                }
                catch (AxisFault axisFault) {
                    this.log.error((Object)"Error setting SOAP envelope", (Throwable)axisFault);
                }
                this.responseMsgCtx.setServerSide(true);
            } else {
                this.responseMsgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
                this.responseMsgCtx.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
            }
            int statusCode = this.response.getStatus();
            this.responseMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
            if (statusCode >= 400) {
                this.responseMsgCtx.setProperty("FAULT_MESSAGE", (Object)"TRUE");
            }
            this.responseMsgCtx.setProperty("NonBlockingTransport", (Object)true);
            try {
                AxisEngine.receive((MessageContext)this.responseMsgCtx);
            }
            catch (AxisFault af) {
                this.log.error((Object)"Fault processing response message through Axis2", (Throwable)af);
            }
        }
        catch (AxisFault af) {
            this.log.error((Object)"Fault creating response SOAP envelope", (Throwable)af);
        }
        catch (IOException e) {
            this.log.error((Object)"Error closing input stream from which message was read", (Throwable)e);
        }
    }

    private String inferContentType() {
        Object cTypeProperty = this.responseMsgCtx.getProperty("CONTENT_TYPE");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.cfgCtx.getAxisConfiguration().getParameter("CONTENT_TYPE");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        return "application/octet-stream";
    }
}

