/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.wso2.carbon.transport.passthru.TargetRequest;
import org.wso2.carbon.transport.passthru.config.TargetConfiguration;
import org.wso2.carbon.transport.passthru.util.PassThroughTransportUtils;

public class TargetRequestFactory {
    private static Log log = LogFactory.getLog(TargetRequestFactory.class);

    public static TargetRequest create(MessageContext msgContext, TargetConfiguration configuration) throws AxisFault {
        try {
            String fullUrl;
            int port;
            String noKeepAlie;
            String forceHttp10;
            String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
            if (httpMethod == null) {
                httpMethod = "POST";
            }
            Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
            EndpointReference epr = PassThroughTransportUtils.getDestinationEPR(msgContext);
            URL url = new URL(epr.getAddress());
            TargetRequest request = new TargetRequest(configuration, url, httpMethod, noEntityBody == null || noEntityBody == false);
            PassThroughTransportUtils.removeUnwantedHeaders(msgContext, configuration.isPreserveServerHeader(), configuration.isPreserveUserAgentHeader());
            Object o = msgContext.getProperty("TRANSPORT_HEADERS");
            if (o != null && o instanceof Map) {
                Map headers = (Map)o;
                for (Map.Entry entryObj : headers.entrySet()) {
                    Map.Entry entry = entryObj;
                    if (entry.getValue() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || "Host".equalsIgnoreCase((String)entry.getKey())) continue;
                    request.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ("true".equals(forceHttp10 = (String)msgContext.getProperty("FORCE_HTTP_1.0"))) {
                request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
            }
            if ("true".equals(noKeepAlie = (String)msgContext.getProperty("NO_KEEPALIVE"))) {
                request.setKeepAlive(false);
            }
            request.setPort((port = url.getPort()) != -1 ? port : 80);
            String disableChunking = (String)msgContext.getProperty("DISABLE_CHUNKING");
            if ("true".equals(disableChunking)) {
                request.setChunk(false);
            }
            if ("true".equals(fullUrl = (String)msgContext.getProperty("FULL_URI"))) {
                request.setFullUrl(true);
            }
            return request;
        }
        catch (MalformedURLException e) {
            TargetRequestFactory.handleException("Invalid to address" + msgContext.getTo().getAddress(), e);
            return null;
        }
    }

    private static void handleException(String s, Exception e) throws AxisFault {
        log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }
}

