/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassThroughTransportUtils {
    private static Log log = LogFactory.getLog(PassThroughTransportUtils.class);

    public static String getHostName(InetAddress address) {
        String hostAddress = address.getHostAddress();
        String inetAddr = address.toString();
        int index1 = inetAddr.lastIndexOf(47);
        int index2 = inetAddr.indexOf(hostAddress);
        String result = index2 == index1 + 1 ? (index1 == 0 ? hostAddress : inetAddr.substring(0, index1)) : hostAddress;
        return result;
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }

    public static void removeUnwantedHeaders(MessageContext msgContext, boolean preserveServerHeader, boolean preserveUserAgentHeader) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if ("Connection".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName) || "Date".equalsIgnoreCase(headerName) || "Keep-Alive".equalsIgnoreCase(headerName)) {
                iter.remove();
            }
            if (!preserveServerHeader && "Server".equalsIgnoreCase(headerName)) {
                iter.remove();
            }
            if (preserveUserAgentHeader || !"User-Agent".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    public static int determineHttpStatusCode(MessageContext msgContext) {
        int httpStatus = 200;
        if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
            httpStatus = 202;
        } else {
            Object statusCode;
            boolean handleFault = msgContext.getEnvelope().getBody().hasFault() || msgContext.isProcessingFault();
            boolean faultsAsHttp200 = "TRUE".equals(msgContext.getProperty("FAULTS_AS_HTTP_200"));
            if (handleFault && !faultsAsHttp200) {
                httpStatus = 500;
            }
            if ((statusCode = msgContext.getProperty("HTTP_SC")) != null) {
                try {
                    httpStatus = Integer.parseInt(msgContext.getProperty("HTTP_SC").toString());
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to set the HTTP status code from the property HTTP_SC with value: " + statusCode));
                }
            }
        }
        return httpStatus;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !PassThroughTransportUtils.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    public String getServicesHTML(String prefix, ConfigurationContext cfgCtx) {
        HashMap services = cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<h2>Deployed services</h2>");
            for (Object service : services.values()) {
                AxisService axisService = (AxisService)service;
                Parameter parameter = axisService.getParameter("hiddenService");
                if (axisService.getName().startsWith("__") || parameter != null && JavaUtils.isTrueExplicitly((Object)parameter.getValue())) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"").append(prefix).append(axisService.getName()).append("?wsdl\">").append(axisService.getName()).append("</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }
}

