/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.connections;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;

public class HostConnections {
    private static final Log log = LogFactory.getLog(HostConnections.class);
    private String host;
    private int port;
    private int maxSize;
    private int pendingConnections;
    private List<NHttpClientConnection> freeConnections = new ArrayList<NHttpClientConnection>();
    private List<NHttpClientConnection> busyConnections = new ArrayList<NHttpClientConnection>();
    private Lock lock = new ReentrantLock();

    public HostConnections(String host, int port, int maxSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new connection pool to the host: " + host + ", port: " + port));
        }
        this.host = host;
        this.port = port;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NHttpClientConnection getConnection() {
        this.lock.lock();
        try {
            if (this.freeConnections.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning an existing free connection to " + this.host + ":" + this.port));
                }
                NHttpClientConnection conn = this.freeConnections.get(0);
                this.freeConnections.remove(conn);
                this.busyConnections.add(conn);
                NHttpClientConnection nHttpClientConnection = conn;
                return nHttpClientConnection;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(NHttpClientConnection conn) {
        conn.getMetrics().reset();
        HttpContext ctx = conn.getContext();
        ctx.removeAttribute("http.request");
        ctx.removeAttribute("http.response");
        this.lock.lock();
        try {
            if (this.busyConnections.remove(conn)) {
                this.freeConnections.add(conn);
            } else {
                log.error((Object)"Attempted to releaseConnection connection not in the busy list");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(NHttpClientConnection conn) {
        this.lock.lock();
        try {
            if (!this.freeConnections.remove(conn)) {
                this.busyConnections.remove(conn);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(NHttpClientConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New connection to " + this.host + ":" + this.port + " is added to the free list"));
        }
        this.lock.lock();
        try {
            this.freeConnections.add(conn);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pendingConnectionSucceeded() {
        this.lock.lock();
        try {
            --this.pendingConnections;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pendingConnectionFailed() {
        this.lock.lock();
        try {
            --this.pendingConnections;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean canHaveMoreConnections() {
        return this.busyConnections.size() + this.pendingConnections < this.maxSize;
    }
}

