/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.config;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.wso2.carbon.transport.passthru.config.BaseConfiguration;
import org.wso2.carbon.transport.passthru.connections.TargetConnections;

public class TargetConfiguration
extends BaseConfiguration {
    private HttpProcessor httpProcessor = null;
    private int maxConnections = Integer.MAX_VALUE;
    private boolean preserveUserAgentHeader = false;
    private boolean preserveServerHeader = true;
    private TargetConnections connections = null;

    public TargetConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool pool) {
        super(configurationContext, parameters, pool);
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue()});
    }

    @Override
    public void build() throws AxisFault {
        super.build();
        this.maxConnections = this.conf.getIntProperty("http.max.connection.per.host.port", Integer.MAX_VALUE);
        this.preserveUserAgentHeader = this.conf.isPreserveUserAgentHeader();
        this.preserveServerHeader = this.conf.isPreserveServerHeader();
    }

    public HttpParams getHttpParameters() {
        return this.httpParameters;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isPreserveUserAgentHeader() {
        return this.preserveUserAgentHeader;
    }

    public boolean isPreserveServerHeader() {
        return this.preserveServerHeader;
    }

    public TargetConnections getConnections() {
        return this.connections;
    }

    public void setConnections(TargetConnections connections) {
        this.connections = connections;
    }
}

