/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.wso2.carbon.transport.passthru.config.BaseConfiguration;
import org.wso2.carbon.transport.passthru.connections.SourceConnections;

public class SourceConfiguration
extends BaseConfiguration {
    private Log log = LogFactory.getLog(SourceConfiguration.class);
    private HttpProcessor httpProcessor = null;
    private HttpResponseFactory responseFactory = null;
    private int port = 8280;
    private SourceConnections sourceConnections = null;
    private TransportInDescription inDescription;
    private String host;
    private String serviceEPRPrefix;
    private String customEPRPrefix;
    private boolean ssl = false;

    public SourceConfiguration(ConfigurationContext configurationContext, TransportInDescription description, WorkerPool pool) {
        super(configurationContext, (ParameterInclude)description, pool);
        this.inDescription = description;
        this.httpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.responseFactory = new DefaultHttpResponseFactory();
        this.sourceConnections = new SourceConnections();
    }

    @Override
    public void build() throws AxisFault {
        super.build();
        this.port = ParamUtils.getRequiredParamInt((ParameterInclude)this.parameters, (String)"port");
        Parameter hostParameter = this.inDescription.getParameter("hostname");
        if (hostParameter != null) {
            this.host = ((String)hostParameter.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        Parameter param = this.inDescription.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.configurationContext, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.configurationContext, this.host, this.port);
            this.customEPRPrefix = this.inDescription.getName() + "://" + this.host + ":" + (this.port == 80 ? "" : Integer.valueOf(this.port)) + "/";
        }
    }

    public HttpParams getHttpParameters() {
        return this.httpParameters;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public HttpResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    public int getPort() {
        return this.port;
    }

    public SourceConnections getSourceConnections() {
        return this.sourceConnections;
    }

    public TransportInDescription getInDescription() {
        return this.inDescription;
    }

    public String getServiceEPRPrefix() {
        return this.serviceEPRPrefix;
    }

    public String getCustomEPRPrefix() {
        return this.customEPRPrefix;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }
}

