/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassThroughConfiguration {
    private static final int DEFAULT_WORKER_POOL_SIZE_CORE = 40;
    private static final int DEFAULT_WORKER_POOL_SIZE_MAX = 200;
    private static final int DEFAULT_WORKER_THREAD_KEEPALIVE_SEC = 60;
    private static final int DEFAULT_WORKER_POOL_QUEUE_LENGTH = -1;
    private static final int DEFAULT_IO_BUFFER_SIZE = 8192;
    private static final int DEFAULT_IO_THREADS_PER_REACTOR = Runtime.getRuntime().availableProcessors();
    private static final Log log = LogFactory.getLog(PassThroughConfiguration.class);
    private static PassThroughConfiguration _instance = new PassThroughConfiguration();
    private Properties props;

    private PassThroughConfiguration() {
        try {
            this.props = PassThroughConfiguration.loadProperties("passthru-http.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PassThroughConfiguration getInstance() {
        return _instance;
    }

    public int getWorkerPoolCoreSize() {
        return this.getIntProperty("worker_pool_size_core", 40);
    }

    public int getWorkerPoolMaxSize() {
        return this.getIntProperty("worker_pool_size_max", 200);
    }

    public int getWorkerThreadKeepaliveSec() {
        return this.getIntProperty("worker_thread_keepalive_sec", 60);
    }

    public int getWorkerPoolQueueLen() {
        return this.getIntProperty("worker_pool_queue_length", -1);
    }

    public int getIOThreadsPerReactor() {
        return this.getIntProperty("io_threads_per_reactor", DEFAULT_IO_THREADS_PER_REACTOR);
    }

    public int getIOBufferSize() {
        return this.getIntProperty("io_buffer_size", 8192);
    }

    public boolean isKeepAliveDisabled() {
        return this.getBooleanProperty("http.connection.disable.keepalive", false);
    }

    public boolean isPreserveUserAgentHeader() {
        return this.getBooleanProperty("http.user.agent.preserve", false);
    }

    public boolean isPreserveServerHeader() {
        return this.getBooleanProperty("http.server.preserve", true);
    }

    private static Properties loadProperties(String filePath) {
        String msg;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading the file '" + filePath + "' from classpath"));
        }
        InputStream in = null;
        if (System.getProperty("conf.location") != null) {
            try {
                in = new FileInputStream(System.getProperty("conf.location") + File.separator + filePath);
            }
            catch (FileNotFoundException e) {
                msg = "Error loading properties from a file at from the System defined location: " + filePath;
                log.warn((Object)msg);
            }
        }
        if (in == null) {
            in = cl.getResourceAsStream(filePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
            filePath = "conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading the file '" + filePath + "'"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                msg = "Error loading properties from a file at : " + filePath;
                log.error((Object)msg, (Throwable)e);
            }
        }
        return properties;
    }

    public Integer getIntProperty(String name, Integer def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            int intVal;
            try {
                intVal = Integer.valueOf(val);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid pass-through http tuning property value. " + name + " must be an integer"));
                return def;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using pass-through http tuning parameter : " + name + " = " + val));
            }
            return intVal;
        }
        return def;
    }

    public Integer getIntProperty(String name) {
        return this.getIntProperty(name, null);
    }

    public Boolean getBooleanProperty(String name, Boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using pass-through http tuning parameter : " + name + " = " + val));
            }
            return Boolean.valueOf(val);
        }
        return def;
    }

    public Boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, null);
    }

    public String getStringProperty(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }
}

