/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru.config;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.params.NIOReactorParams;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.config.PassThroughConfiguration;
import org.wso2.carbon.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.wso2.carbon.transport.passthru.util.BufferFactory;

public abstract class BaseConfiguration {
    private Log log = LogFactory.getLog(BaseConfiguration.class);
    protected ParameterInclude parameters = null;
    private WorkerPool workerPool = null;
    protected ConfigurationContext configurationContext = null;
    protected HttpParams httpParameters = null;
    protected BufferFactory bufferFactory = null;
    private PassThroughTransportMetricsCollector metrics = null;
    private int iOThreadsPerReactor;
    private int iOBufferSize;
    protected PassThroughConfiguration conf = PassThroughConfiguration.getInstance();

    public BaseConfiguration(ConfigurationContext configurationContext, ParameterInclude parameters, WorkerPool workerPool) {
        this.parameters = parameters;
        this.workerPool = workerPool;
        this.configurationContext = configurationContext;
    }

    public void build() throws AxisFault {
        this.iOThreadsPerReactor = this.conf.getIOThreadsPerReactor();
        this.iOBufferSize = this.conf.getIOBufferSize();
        if (this.workerPool == null) {
            this.workerPool = WorkerPoolFactory.getWorkerPool((int)this.conf.getWorkerPoolCoreSize(), (int)this.conf.getWorkerPoolMaxSize(), (int)this.conf.getWorkerThreadKeepaliveSec(), (int)this.conf.getWorkerPoolQueueLen(), (String)"Pass-through Message Processing Thread Group", (String)"PassThroughMessageProcessor");
        }
        this.httpParameters = this.retrieveHttpParameters();
        this.bufferFactory = new BufferFactory(8192, (ByteBufferAllocator)new HeapByteBufferAllocator(), 512);
    }

    public int getIOThreadsPerReactor() {
        return this.iOThreadsPerReactor;
    }

    public int getIOBufferSize() {
        return this.iOBufferSize;
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    protected HttpParams retrieveHttpParameters() throws AxisFault {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", this.conf.getIntProperty("http.socket.timeout", 60000).intValue()).setIntParameter("http.connection.timeout", this.conf.getIntProperty("http.connection.timeout", 0).intValue()).setIntParameter("http.socket.buffer-size", this.conf.getIntProperty("http.socket.buffer-size", 8192).intValue()).setBooleanParameter("http.connection.stalecheck", this.conf.getBooleanProperty("http.connection.stalecheck", false).booleanValue()).setBooleanParameter("http.tcp.nodelay", this.conf.getBooleanProperty("http.tcp.nodelay", true).booleanValue()).setBooleanParameter("http.nio.interest-ops-queueing", this.conf.getBooleanProperty("http.nio.interest-ops-queueing", false).booleanValue()).setParameter("http.origin-server", (Object)this.conf.getStringProperty("http.origin-server", "WSO2-PassThrough-HTTP"));
        if (this.conf.getIntProperty("http.socket.linger") != null) {
            HttpConnectionParams.setLinger((HttpParams)params, (int)this.conf.getIntProperty("http.socket.linger"));
        }
        if (this.conf.getBooleanProperty("http.socket.reuseaddr") != null) {
            HttpConnectionParams.setSoReuseaddr((HttpParams)params, (boolean)this.conf.getBooleanProperty("http.socket.reuseaddr"));
        }
        if (this.conf.getIntProperty("http.nio.select-interval") != null) {
            NIOReactorParams.setSelectInterval((HttpParams)params, (long)this.conf.getIntProperty("http.nio.select-interval").intValue());
        }
        return params;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public PassThroughTransportMetricsCollector getMetrics() {
        return this.metrics;
    }

    public void setMetrics(PassThroughTransportMetricsCollector metrics) {
        this.metrics = metrics;
    }
}

