/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.wso2.carbon.transport.passthru.Pipe;
import org.wso2.carbon.transport.passthru.ProtocolState;
import org.wso2.carbon.transport.passthru.SourceContext;
import org.wso2.carbon.transport.passthru.config.SourceConfiguration;

public class SourceRequest {
    private Pipe pipe = null;
    private String url;
    private String method;
    private boolean entityEnclosing;
    private HttpRequest request = null;
    private SourceConfiguration sourceConfiguration;
    private ProtocolVersion version = null;
    private NHttpServerConnection connection = null;

    public SourceRequest(SourceConfiguration sourceConfiguration, HttpRequest request, NHttpServerConnection conn) {
        this.sourceConfiguration = sourceConfiguration;
        this.request = request;
        this.connection = conn;
        this.url = request.getRequestLine().getUri();
        this.method = request.getRequestLine().getMethod();
        this.entityEnclosing = request instanceof HttpEntityEnclosingRequest;
        this.version = request.getProtocolVersion();
        this.version = request.getRequestLine().getProtocolVersion();
        if (!this.version.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            this.version = HttpVersion.HTTP_1_1;
        }
    }

    public void start(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.entityEnclosing) {
            this.pipe = new Pipe((IOControl)conn, this.sourceConfiguration.getBufferFactory().getBuffer(), "source");
            SourceContext.get((NHttpConnection)conn).setReader(this.pipe);
            if (((HttpEntityEnclosingRequest)this.request).expectContinue()) {
                BasicHttpResponse ack = new BasicHttpResponse(this.version, 100, "Continue");
                conn.submitResponse((HttpResponse)ack);
            }
        } else {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
            conn.suspendInput();
        }
    }

    public int read(NHttpServerConnection conn, ContentDecoder decoder) throws IOException {
        if (this.pipe == null) {
            throw new IllegalStateException("A Pipe must be connected before calling read");
        }
        if (this.entityEnclosing) {
            int bytes = this.pipe.produce(decoder);
            if (decoder.isCompleted()) {
                this.sourceConfiguration.getMetrics().notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
                SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
                conn.suspendInput();
            }
            return bytes;
        }
        throw new IllegalStateException("Only Entity Enclosing Requests can read content in to the pipe");
    }

    public Map<String, String> getAllHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : this.request.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    public String getHeader(String name) {
        Header header = this.request.getFirstHeader(name);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public String getUri() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public NHttpServerConnection getConnection() {
        return this.connection;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public boolean isEntityEnclosing() {
        return this.entityEnclosing;
    }
}

