/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.passthru;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.impl.nio.SSLClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;
import org.wso2.carbon.transport.passthru.logging.LoggingUtils;

public class SSLTargetIOEventDispatch
extends SSLClientIOEventDispatch {
    private Map<String, SSLContext> contextMap;
    private HttpParams params = null;

    public SSLTargetIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLIOSessionHandler sslHandler, HttpParams params) {
        super(handler, sslcontext, sslHandler, params);
        this.params = params;
    }

    public void setContextMap(Map<String, SSLContext> contextMap) {
        this.contextMap = contextMap;
    }

    protected SSLIOSession createSSLIOSession(IOSession session, SSLContext sslcontext, SSLIOSessionHandler sslHandler) {
        InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
        String host = address.getHostName() + ":" + address.getPort();
        SSLContext customContext = null;
        if (this.contextMap != null) {
            customContext = this.contextMap.get(host);
        }
        if (customContext == null) {
            customContext = sslcontext;
        }
        return super.createSSLIOSession(session, customContext, sslHandler);
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        session = LoggingUtils.decorate(session, "sslclient");
        return LoggingUtils.createClientConnection(session, this.createHttpResponseFactory(), this.createByteBufferAllocator(), this.params);
    }
}

