/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v3.sourcegen;

import ca.uhn.hl7v3.sourcegen.AttributeDefinition;
import ca.uhn.hl7v3.sourcegen.CMPClassGenerator;
import ca.uhn.hl7v3.sourcegen.ClassDefinition;
import ca.uhn.hl7v3.sourcegen.DataTypeDefinition;
import ca.uhn.hl7v3.sourcegen.DataTypeGenerator;
import ca.uhn.hl7v3.sourcegen.DefinitionLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;

public class SourceGenerator {
    public static void writeEJBCode(File baseDirectory, Connection conn) throws Exception {
        File rimDir = SourceGenerator.prepDirectories(baseDirectory);
        DefinitionLoader dl = new DefinitionLoader(conn);
        String[] classes = dl.getRIMClassNames();
        for (int i = 0; i < classes.length; ++i) {
            SourceGenerator.writeEJBCode(rimDir, classes[i], conn);
        }
        String[] datatypes = dl.getRIMDataTypeNames();
        File dtDir = new File(rimDir, "datatype");
        for (int i = 0; i < datatypes.length; ++i) {
            SourceGenerator.writeDataTypeCode(dtDir, datatypes[i], conn);
        }
    }

    private static File prepDirectories(File baseDirectory) throws Exception {
        if (!baseDirectory.isDirectory()) {
            throw new Exception("The specified base directory " + baseDirectory.toString() + " is not a directory.");
        }
        File rimDir = new File(baseDirectory, SourceGenerator.getRIMPackage().replace('.', File.separatorChar));
        File dtDir = new File(rimDir, "datatype");
        dtDir.mkdirs();
        return rimDir;
    }

    public static void writeEJBCode(File rimDir, String RIMClass2, Connection conn) throws Exception {
        DefinitionLoader dl = new DefinitionLoader(conn);
        ClassDefinition def = dl.getRIMClassDef(RIMClass2);
        CMPClassGenerator gen = new CMPClassGenerator();
        BufferedWriter home = new BufferedWriter(new FileWriter(new File(rimDir, def.getName() + "Home.java")));
        home.write(gen.makeHomeCode(def));
        home.flush();
        home.close();
        BufferedWriter remote = new BufferedWriter(new FileWriter(new File(rimDir, def.getName() + ".java")));
        remote.write(gen.makeRemoteCode(def));
        remote.flush();
        remote.close();
        BufferedWriter bean = new BufferedWriter(new FileWriter(new File(rimDir, def.getName() + "Bean.java")));
        bean.write(gen.makeBeanCode(def));
        bean.flush();
        bean.close();
    }

    public static void writeDataTypeCode(File dtDir, String dataType, Connection conn) throws Exception {
        DefinitionLoader dl = new DefinitionLoader(conn);
        DataTypeDefinition def = dl.getDataTypeDef(dataType);
        DataTypeGenerator gen = new DataTypeGenerator();
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(dtDir, def.getName() + ".java")));
        out.write(gen.makeDataType(def));
        out.flush();
        out.close();
    }

    public static String makeSetterSignature(AttributeDefinition att) {
        StringBuffer code = new StringBuffer();
        code.append("public void set");
        code.append(att.getName().substring(0, 1).toUpperCase());
        code.append(att.getName().substring(1, att.getName().length()));
        code.append("(");
        code.append(att.getDataType());
        code.append(" ");
        code.append(att.getName());
        code.append(")");
        return code.toString();
    }

    public static String makeGetterSignature(AttributeDefinition att) {
        StringBuffer code = new StringBuffer();
        code.append("public ");
        code.append(att.getDataType());
        code.append(" get");
        code.append(att.getName().substring(0, 1).toUpperCase());
        code.append(att.getName().substring(1, att.getName().length()));
        code.append("()");
        return code.toString();
    }

    public static String getRIMPackage() {
        return "ca.uhn.hl7v3.rim";
    }

    public static String getRIMDataTypePackage() {
        return "ca.uhn.hl7v3.rim.datatype";
    }

    public static String makeJavaDocComment(String description, int indent) {
        if (description == null) {
            return SourceGenerator.spaces(indent) + "/** */ \r\n";
        }
        int width = 70 - indent;
        StringBuffer comment = new StringBuffer();
        comment.append(SourceGenerator.spaces(indent));
        comment.append("/** \r\n");
        boolean done = false;
        int start = 0;
        while (!done) {
            comment.append(SourceGenerator.spaces(indent));
            comment.append(" * ");
            int lineBreak = SourceGenerator.findLineBreak(description, start, width);
            comment.append(description.substring(start, lineBreak).trim());
            comment.append(" \r\n");
            if (lineBreak == description.length()) {
                done = true;
                continue;
            }
            start = lineBreak;
        }
        comment.append(SourceGenerator.spaces(indent));
        comment.append(" */ \r\n");
        return comment.toString();
    }

    private static String spaces(int numSpaces) {
        StringBuffer spaces = new StringBuffer();
        for (int i = 0; i < numSpaces; ++i) {
            spaces.append(" ");
        }
        return spaces.toString();
    }

    public static int findLineBreak(String s, int start, int maxLength) {
        int lineBreak = start + maxLength;
        int existingCarriageReturnLoc = s.indexOf(13, start);
        if (existingCarriageReturnLoc > -1 && existingCarriageReturnLoc < lineBreak) {
            lineBreak = existingCarriageReturnLoc + 1;
        } else if (lineBreak >= s.length()) {
            lineBreak = s.length();
        } else {
            boolean found = false;
            while (!found) {
                char c = s.charAt(lineBreak);
                if (Character.isWhitespace(c)) {
                    found = true;
                    ++lineBreak;
                    continue;
                }
                --lineBreak;
            }
        }
        return lineBreak;
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: SourceGenerator base_directory [RIM_class]");
            System.exit(1);
        }
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            Connection conn = DriverManager.getConnection("jdbc:odbc:RIM");
            File base = new File(args[0]);
            base.mkdirs();
            if (args.length == 1) {
                SourceGenerator.writeEJBCode(base, conn);
            } else {
                SourceGenerator.writeEJBCode(base, args[1], conn);
            }
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

