/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.app.TestApplication;
import ca.uhn.hl7v2.validation.impl.ConformanceProfileRule;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;

public class ProfileTestApplication
extends TestApplication {
    private static final HapiLog log = HapiLogFactory.getHapiLog(ProfileTestApplication.class);
    private String profileID;
    private ConformanceProfileRule rule;

    public ProfileTestApplication() {
        this.rule = new ConformanceProfileRule();
    }

    public ProfileTestApplication(String profileID) {
        this.profileID = profileID;
        this.rule = new ConformanceProfileRule(profileID);
    }

    public boolean canProcess(Message in) {
        return true;
    }

    public HL7Exception[] test(Message in) throws HL7Exception {
        ValidationException[] errors = this.rule.test(in);
        HL7Exception[] result = new HL7Exception[errors.length];
        for (int i = 0; i < errors.length; ++i) {
            Throwable t = errors[i].getCause();
            result[i] = t != null && t instanceof HL7Exception ? (HL7Exception)t : new HL7Exception(errors[i]);
        }
        return result;
    }

    public String getProfileID() {
        return this.profileID;
    }
}

