/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.util.Home;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class Status {
    private int dest = 0;
    private int detail = 0;
    private BufferedWriter fileOut;
    private static Status singleton = null;
    public static final int STANDARD_OUT = 1;
    public static final int FILE = 2;
    public static final int NONE = 3;
    public static final int STANDARD = 4;
    public static final int VERBOSE = 5;

    private Status() {
        String out = System.getProperty("ca.uhn.hl7v2.util.status.out");
        String level = System.getProperty("ca.uhn.hl7v2.util.status.level");
        if (out != null && out.equals("FILE")) {
            this.setOutput(2);
        } else {
            this.setOutput(1);
        }
        if (level != null && level.equals("NONE")) {
            this.setVerbosity(3);
        } else if (level != null && level.equals("VERBOSE")) {
            this.setVerbosity(5);
        } else {
            this.setVerbosity(4);
        }
    }

    public synchronized void setOutput(int destination) {
        if (destination == 1 || destination == 2) {
            this.dest = destination;
            if (this.dest == 1) {
                System.out.println("Outputting status messages to standard out.");
            } else {
                String file = Home.getHomeDirectory().getAbsolutePath() + "/status.log";
                System.out.println("Outputting status messages to the file " + file);
                try {
                    this.fileOut = new BufferedWriter(new FileWriter(file, true));
                }
                catch (IOException e) {
                    System.err.println("Couldn't open file status.log for status output - using std out instead.");
                    this.dest = 1;
                }
            }
        }
    }

    public synchronized void setVerbosity(int level) {
        if (level == 3 || level == 4 || level == 5) {
            this.detail = level;
            if (this.detail == 3) {
                System.out.println("ca.uhn.hl7v2.util.Status: No status messages will be output.");
            } else if (this.detail == 4) {
                System.out.println("ca.uhn.hl7v2.util.Status: Standard status messages will be output.");
            } else {
                System.out.println("ca.uhn.hl7v2.util.Status: Verbose status messages will be output.");
            }
        }
    }

    public static void writeStatus(String message) {
        if (singleton == null) {
            singleton = new Status();
        }
        singleton.writeStatus(message, false);
    }

    public static void writeVerboseStatus(String message) {
        if (singleton == null) {
            singleton = new Status();
        }
        singleton.writeStatus(message, true);
    }

    private synchronized void writeStatus(String message, boolean verbose) {
        boolean output = true;
        if (this.detail == 3 || verbose && this.detail != 5) {
            output = false;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        StringBuffer mess = new StringBuffer();
        mess.append(now.get(5));
        mess.append("/");
        mess.append(now.get(3));
        mess.append("/");
        mess.append(now.get(1));
        mess.append(" ");
        mess.append(now.get(11));
        mess.append(":");
        mess.append(now.get(12));
        mess.append(":");
        mess.append(now.get(13));
        mess.append(".");
        mess.append(now.get(14));
        mess.append("  ");
        mess.append(message);
        if (output) {
            if (this.dest == 1) {
                System.out.println(mess.toString());
            } else {
                try {
                    this.fileOut.write(mess.toString());
                    this.fileOut.write("\r\n");
                    this.fileOut.flush();
                }
                catch (IOException e) {
                    System.err.println("Error writing status message to file: " + e.getMessage());
                    System.out.println(mess.toString());
                }
            }
        }
    }
}

