/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.preparser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.preparser.DatumPath;
import ca.uhn.hl7v2.preparser.ER7;
import ca.uhn.hl7v2.preparser.XML;
import ca.uhn.hl7v2.util.Terser;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PreParser {
    private static GenericParser ourParser = new GenericParser();

    public static String[] getFields(String theMessageText, String[] thePathSpecs) throws HL7Exception {
        DatumPath[] paths = new DatumPath[thePathSpecs.length];
        for (int i = 0; i < thePathSpecs.length; ++i) {
            StringTokenizer tok = new StringTokenizer(thePathSpecs[i], "-", false);
            String segSpec = tok.nextToken();
            String segName = (tok = new StringTokenizer(segSpec, "()", false)).nextToken();
            if (segName.length() != 3) {
                throw new HL7Exception("In field path, " + segName + " is not a valid segment name");
            }
            int segRep = 0;
            if (tok.hasMoreTokens()) {
                String rep = tok.nextToken();
                try {
                    segRep = Integer.parseInt(rep);
                }
                catch (NumberFormatException e) {
                    throw new HL7Exception("In field path, segment rep" + rep + " is not valid", e);
                }
            }
            int[] indices = Terser.getIndices(thePathSpecs[i]);
            paths[i] = new DatumPath();
            paths[i].add(segName).add(segRep);
            paths[i].add(indices[0]).add(indices[1]).add(indices[2]).add(indices[3]);
        }
        return PreParser.getFields(theMessageText, paths);
    }

    private static String[] getFields(String theMessageText, DatumPath[] thePaths) throws HL7Exception {
        String[] fields = new String[thePaths.length];
        String encoding = ourParser.getEncoding(theMessageText);
        Properties props = new Properties();
        Vector<DatumPath> mask = new Vector<DatumPath>();
        for (int i = 0; i < thePaths.length; ++i) {
            mask.add(thePaths[i]);
        }
        if (encoding == null) {
            throw new HL7Exception("Message encoding is not recognized");
        }
        boolean OK = false;
        if (encoding.equals("VB")) {
            OK = ER7.parseMessage(props, mask, theMessageText);
        } else if (encoding.equals("XML")) {
            OK = XML.parseMessage(props, theMessageText, null);
        }
        if (!OK) {
            throw new HL7Exception("Parse failed");
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = props.getProperty(thePaths[i].toString());
        }
        return fields;
    }
}

