/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TQ;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class INV
extends AbstractSegment {
    public INV(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage(), new Integer(451)}, "Substance Identifier");
            this.add(CWE.class, true, 0, 705, new Object[]{this.getMessage(), new Integer(383)}, "Substance Status");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(384)}, "Substance Type");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(9999)}, "Inventory Container Identifier");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(9999)}, "Container Carrier Identifier");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(9999)}, "Position on Carrier");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Initial Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Current Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Available Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Consumption Quantity");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(9999)}, "Quantity Units");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Expiration Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "First Used Date/Time");
            this.add(TQ.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(0)}, "On Board Stability Duration");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(9999)}, "Test/Fluid Identifier(s)");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage(), new Integer(0)}, "Manufacturer Lot Number");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(385)}, "Manufacturer Identifier");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(386)}, "Supplier Identifier");
            this.add(CQ.class, false, 1, 722, new Object[]{this.getMessage(), new Integer(0)}, "On Board Stability Time");
            this.add(CQ.class, false, 1, 722, new Object[]{this.getMessage(), new Integer(0)}, "Target Value");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating INV - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getSubstanceIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv1_SubstanceIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getSubstanceStatus() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSubstanceStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE getSubstanceStatus(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv2_SubstanceStatus(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInv2_SubstanceStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertSubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeSubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE getSubstanceType() {
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv3_SubstanceType() {
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInventoryContainerIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv4_InventoryContainerIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getContainerCarrierIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv5_ContainerCarrierIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPositionOnCarrier() {
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv6_PositionOnCarrier() {
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInitialQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInv7_InitialQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getCurrentQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInv8_CurrentQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getAvailableQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInv9_AvailableQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getConsumptionQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInv10_ConsumptionQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getQuantityUnits() {
        CWE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv11_QuantityUnits() {
        CWE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getExpirationDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getInv12_ExpirationDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getFirstUsedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getInv13_FirstUsedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TQ getOnBoardStabilityDuration() {
        TQ ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TQ getInv14_OnBoardStabilityDuration() {
        TQ ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getTestFluidIdentifierS() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(15);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getTestFluidIdentifierSReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE getTestFluidIdentifierS(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv15_TestFluidIdentifierS(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInv15_TestFluidIdentifierSReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removeInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public ST getManufacturerLotNumber() {
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getInv16_ManufacturerLotNumber() {
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getManufacturerIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv17_ManufacturerIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getSupplierIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInv18_SupplierIdentifier() {
        CWE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getOnBoardStabilityTime() {
        CQ ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getInv19_OnBoardStabilityTime() {
        CQ ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTargetValue() {
        CQ ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getInv20_TargetValue() {
        CQ ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new TQ(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

